(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                mimick.mli                                *)
(****************************************************************************)

open Std
open More_util
open Names
open Generic
open Generic
open Term
open Proof_trees
open Tacmach
open Pfedit
open Evd
val inProof : string -> proof_tree
val outProof : string -> proof_tree -> unit

val saveProof : string -> unit
val readProof : string -> proof_tree
val associateProof : proof_tree -> tactic
val eraseProof : tactic
val eq_goal : goal -> goal -> bool
val mimick : proof_tree -> tactic

type ttactic = proof_tree -> proof_tree list * (proof_tree list -> proof_tree)

val elideTactics : string list -> ttactic

val show_mimick_script : unit -> unit

(* $Id: mimick.mli,v 1.8 1999/06/29 07:47:59 loiseleu Exp $ *)
