(**************************************************************************
  **                     ntprooftext1.ml                                 **
  **************************************************************************)
open Pp;;
open Std;;
open Names;;
open More_util;;
open Generic;;
open Term;;
open Ntdef;;
open Ntsons;;
open Ntaux;;
open Ntpprinter;;

(**************************************************************************
  *******************          somes tools              *******************
  *************************************************************************
  *************************************************************************
  *********                     dots                              *********
  **************************************************************************)
let pr_dot_top _ = [< 'sTR ". " >];;

let pr_dot_mid _ = [< 'sTR "  " >];;

let pr_dot_dot _ = [< 'sTR "* " >];;

let pr_dot i nc =
 match nc_dot i nc with
 | 'T' -> !p_dot_top nc
 | 'M' -> !p_dot_mid nc
 | 'D' -> !p_dot_dot nc
 | _ -> [< 'sTR "ERROR pr_dot" >];;

let pr_indent _ = [< 'sTR "  " >];;

(**************************************************************************
  *********                     print_annotation                  *********
  **************************************************************************)
let nc_atm_text_int i = !p_text_int i;;

let nc_atm_lambda_text_var_list_length nc =
 !p_text_int (nc_lambda_var_list_length nc);;

let nc_atm_text_nbr_elim_cases nc = !p_text_int (nc_nbr_elim_cases nc);;

(*value  : natural_constr -> int;;*)
let pr_lambda_binder_type nc =
 match nc_body nc with
 | DOP2 ((Inl Lambda), t, _) -> pr_nc t
 | _ -> [< 'sTR "ERROR pr_lambda_binder_type" >];;

let pr_case_number nc =
 match nc_get_n_a nc with
 | Na_app_son (_,_, (Nase_case (_, _, _, _, (Some l)))) ->
  let f i = [< 'sTR (string_of_int i); 'sTR "." >] in
  prlist f l
 | _ -> [< 'sTR "ERROR pr_case_number" >];;

let pr_nbr_cases nc =
 match nc_get_n_i nc with
 | Ni_app (_, (Nauc_elim (_, (_, i, _)))) -> !p_text_int i
 | _ -> [< 'sTR "ERROR pr_nbr_cases" >];;

let pr_induct_cst f_call nc =
 match nc_get_n_i nc with
 | Ni_id (Nin_construct cst) -> !f_call cst
 | Ni_id (Nin_elim_theorem cst) -> !f_call cst
 | Ni_app ((_, (Some (_, _, cst))), _) -> !f_call cst
 | _ -> [< 'sTR "ERROR pr_induct_cst" >];;

let pr_cst c = pr_c c;;

let pr_fix_case_name nc =
 match nc_get_n_a nc with
 | Na_fix_son (id, _) -> [< 'sTR (string_of_id id) >]
 | _ -> [< 'sTR "ERROR pr_fix_case_name" >];;

let pr_fix_case_type nc =
 match nc_get_n_a nc with
 | Na_fix_son (_, t) -> pr_c t
 | _ -> [< 'sTR "ERROR pr_fix_case_type" >];;

let pr_type_1 nc =
 match nc_get_type_list_if_used nc with
 | t :: _ -> !p_type_formula t
 | _ -> [< 'sTR "ERROR pr_type_1" >];;

let pr_type_2 nc =
 match nc_get_type_list_if_used nc with
 | _ :: (t :: _) -> !p_type_formula t
 | _ -> [< 'sTR "ERROR pr_type_2" >];;

let pr_type_3 nc =
 match nc_get_type_list_if_used nc with
 | _ :: (_ :: (t :: _)) -> !p_type_formula t
 | _ -> [< 'sTR "ERROR pr_type_3" >];;

let pr_type_1_bis nc =
 match nc_get_type_list_if_used nc with
 | t :: _ -> !p_type_formula_bis t
 | _ -> [< 'sTR "ERROR pr_type_1_bis" >];;

let pr_type_2_bis nc =
 match nc_get_type_list_if_used nc with
 | _ :: (t :: _) -> !p_type_formula_bis t
 | _ -> [< 'sTR "ERROR pr_type_2_bis" >];;

let pr_type_3_bis nc =
 match nc_get_type_list_if_used nc with
 | _ :: (_ :: (t :: _)) -> !p_type_formula_bis t
 | _ -> [< 'sTR "ERROR pr_type_3_bis" >];;

(**************************************************************************
  *******************       imcomplete text rule        *******************
  *************************************************************************
  *************************************************************************
  *********                lambda abstraction           *******************
  **************************************************************************)
let pr_lambda_son f_call nc =
 try !f_call (nc_lambda_son nc)
 with
 | UserError ("ntsons__nc_lambda_son", _) -> [< 'sTR "ERROR pr_lambda_son" >];;

let rec pr_lambda_var_list nc =
 try match nc_body nc with
  | DOP2 ((Inl Lambda), _, (DLAM (na, _))) ->
   (match nc_lambda_var_right nc with
   | 0 -> pr_name na
   | 1 ->
    [< pr_name na; s' " "; !p_text_and nc; s' " ";
     pr_lambda_var_list (nc_lambda_son nc) >]
   | _ -> [< pr_name na; s' ", "; pr_lambda_var_list (nc_lambda_son nc) >])
  | _ -> [< s' "ERROR pr_lambda_var_list" >]
 with
 | UserError ("ntsons__nc_lambda_son", _) -> [< 'sTR "ERROR pr_lambda_var_list" >];;

let pr_lambda_var_list_hyp nc = pr_lambda_var_list nc;;

(**************************************************************************
  *********                  application                *******************
  **************************************************************************)
let pr_apply_head f_call nc =
 try !f_call (nc_apply_head nc)
 with
 | UserError ("ntsons__nc_apply_head", _) -> [< 'sTR "ERROR pr_apply_head" >];;

let pr_apply_sub_horiz nc =
 try match List.rev (nc_rec_apply_subs nc) with
  | nc2 :: (nc1 :: l) ->
   let f nc = [< !p_id nc; 'sTR ","; 'sPC >] in
   h' [< prlist f (List.rev l); !p_id nc1; 'sPC; !p_text_and nc; 'sPC; !p_id nc2 >]
  | nc :: [] -> !p_id nc
  | _ -> [< 'sTR "ERROR pr_apply_sub_horiz" >]
 with
 | UserError ("ntsons__nc_rec_apply_subs", _) ->
 [< 'sTR "ERROR pr_apply_sub_horiz" >];;

let pr_apply_sub_horiz_cap nc =
 try match List.rev (nc_rec_apply_subs nc) with
  | nc2 :: (nc1 :: l) ->
   let f nc = [< !p_id_cap nc; 'sTR ","; 'sPC >] in
   h'
    [< prlist f (List.rev l); !p_id_cap nc1; 'sPC; !p_text_and nc; 'sPC;
    !p_id_cap nc2 >]
  | nc :: [] -> !p_id_cap nc
  | _ -> [< 'sTR "ERROR pr_apply_sub_horiz_cap" >]
 with
 | UserError ("ntsons__nc_rec_apply_subs", _) ->
 [< 'sTR "ERROR pr_apply_sub_horiz_cap" >];;

let pr_apply_sub_horiz_expl nc =
 try match List.rev (nc_rec_apply_subs nc) with
  | nc2 :: (nc1 :: l) ->
   let f nc = [< !p_id_expl nc; 'sTR ","; 'sPC >] in
   h'
    [< prlist f (List.rev l); !p_id_expl nc1; 'sPC; !p_text_and nc; 'sPC;
    !p_id_expl nc2 >]
  | nc :: [] -> !p_id nc
  | _ -> [< 'sTR "ERROR pr_apply_sub_horiz_expl" >]
 with
 | UserError ("ntsons__nc_rec_apply_subs", _) ->
 [< 'sTR "ERROR pr_apply_sub_horiz_expl" >];;

(**************************************************************************
  *********                   elimination                         *********
  **************************************************************************)
let pr_elim_head f_call nc =
 try !f_call (nc_elim_head nc)
 with
 | UserError ("ntsons__nc_elim_head", _) -> [< 'sTR "ERROR pr_elim_head" >];;

(**************************************************************************
  *******************          complete rule            *******************
  *************************************************************************
  *************************************************************************
  *********                      head                             *********
  **************************************************************************)
let pr_apply_head_vert nc =
 try !p_all (nc_apply_head nc)
 with
 | UserError ("ntsons__nc_apply_head", _) -> [< 'sTR "ERROR pr_apply_head_vert" >];;

let pr_elim_head_vert nc =
 try !p_all (nc_elim_head nc)
 with
 | UserError ("ntsons__nc_elim_head", _) -> [< 'sTR "ERROR pr_elim_head_vert" >];;

(**************************************************************************
  *********                      body                             *********
  **************************************************************************)
let rec pr_lambda_body nc =
 try let son = nc_lambda_son nc in
     if nc_is_lambda_right_0 nc then (!p_all son)
      else pr_lambda_body son
 with
 | UserError ("ntsons__nc_lambda_son", _) -> [< 'sTR "ERROR pr_lambda_body" >];;

let pr_apply_body nc =
 try let sep () = [< 'cUT >] in
     v' [< prlist_with_sep sep !p_all (nc_rec_apply_subs nc) >]
 with
 | UserError ("ntsons__nc_rec_apply_subs", _) -> [< 'sTR "ERROR pr_apply_body" >];;

let pr_elim_body_aux nc =
 v'
 [<
 if nc_is_some_case_number nc then
  [< !p_elim_case_intro nc; 'cUT; !p_indent nc >]
  else [< >]; match nc_elim_case_nat nc with
               | Ncn_triv -> if nc_is_lambda_in_case nc then (!p_text_intro nc)
                              else (!p_text_concl nc)
               | _ -> !p_all nc >];;

let rec pr_elim_body nc =
 let sep () = [< 'cUT >] in
 try let cases = nc_rec_elim_cases nc in
     v' [< prlist_with_sep sep pr_elim_body_aux cases >]
 with
 | UserError ("ntsons__nc_rec_elim_cases", _) -> [< 'sTR "ERROR pr_elim_body" >];;

let pr_fix_body_aux nc =
 v' [< !p_fix_case_intro nc; 'cUT; !p_indent nc; !p_all nc >];;

let pr_fix_body nc =
 let sep () = [< 'cUT >] in
 try let sons = nc_fix_sons nc in
     v' [< prlist_with_sep sep pr_fix_body_aux sons >]
 with
 | UserError ("ntsons__nc_fix_sons", _) -> [< 'sTR "ERROR pr_fix_body" >];;

let pr_misc_body nc = pr_nc nc;;

(**************************************************************************
  *******************             text format           *******************
  **************************************************************************)
let pr_text_intro nc =
 match nc_select_rule 'I' nc with
 | "L" -> !p_lambda_intro nc
 | "AS" -> !p_apply_std_intro nc
 | "AO" -> !p_apply_omit_intro nc
 | "AC" -> !p_apply_construct_intro nc
 | "EM" -> !p_elim_match_intro nc
 | "EM1" -> !p_elim_match_one_intro nc
 | "EMabs" -> !p_elim_match_absurd_intro nc
 | "EI" -> !p_elim_induc_intro nc
 | "TR" -> !p_trivial_intro nc
 | "M" -> !p_misc_intro nc
 | str -> [< 'sTR ("ERROR pr_text_intro >" ^ str ^ "<") >];;

let pr_text_head nc =
 match nc_select_rule 'H' nc with
 | "A" -> !p_apply_head_vert nc
 | "E" | "E1" -> !p_elim_head_vert nc
 | str -> [< 'sTR ("ERROR pr_text_head >" ^ str ^ "<") >];;

let pr_text_body nc = h' [< if nc_select_elements 'B' nc = 1 then (!p_indent nc)
                             else [< >]; match nc_select_rule 'B' nc with
                                          | "L" -> !p_lambda_body nc
                                          | "A" -> !p_apply_body nc
                                          | "E" -> !p_elim_body nc
                                          | "F" -> !p_fix_body nc
                                          | "M" -> !p_misc_body nc
                                          | str ->
                                           [<
                                            'sTR
                                             ("ERROR pr_text_body >" ^ str ^ "<")
                                            >] >];;

let pr_text_concl nc =
 match nc_select_rule 'C' nc with
 | "L" -> !p_lambda_concl nc
 | "AS" -> !p_apply_std_concl nc
 | "ASsp" -> !p_apply_std_specialization_concl nc
 | "AO" -> !p_apply_omit_concl nc
 | "AOsp" -> !p_apply_omit_specialization_concl nc
 | "AC" -> !p_apply_construct_concl nc
 | "ACsp" -> !p_apply_construct_specialization_concl nc
 | "EM" -> !p_elim_match_concl nc
 | "EM0" -> !p_elim_match_no_case_concl nc
 | "EM1" -> !p_elim_match_one_concl nc
 | "EMtr" -> !p_elim_match_trivial_concl nc
 | "EMabs" -> !p_elim_match_absurd_concl nc
 | "EI" -> !p_elim_induc_concl nc
 | "F" -> !p_fix_concl nc
 | "ID" -> !p_identifier_concl nc
 | "MV" -> !p_metavar_concl nc
 | "TR" -> !p_trivial_concl nc
 | "M" -> !p_misc_concl nc
 | str -> [< 'sTR ("ERROR pr_text_concl >" ^ str ^ "<") >];;

let pr_all nc =
 if nc_is_with_dot nc then v' [< (match nc_select_rule_family 1 nc with
                                  | 'I' -> [< !p_dot 1 nc; !p_text_intro nc >]
                                  | 'H' -> [< !p_dot 1 nc; !p_text_head nc >]
                                  | 'B' -> [< !p_dot 1 nc; !p_text_body nc >]
                                  | 'C' -> [< !p_dot 1 nc; !p_text_concl nc >]
                                  | _ -> [< >]);
 (match nc_select_rule_family 2 nc with
  | 'I' -> [< 'cUT; !p_dot 2 nc; !p_text_intro nc >]
  | 'H' -> [< 'cUT; !p_dot 2 nc; !p_text_head nc >]
  | 'B' -> [< 'cUT; !p_dot 2 nc; !p_text_body nc >]
  | 'C' -> [< 'cUT; !p_dot 2 nc; !p_text_concl nc >]
  | _ -> [< >]); (match nc_select_rule_family 3 nc with
                  | 'I' -> [< 'cUT; !p_dot 3 nc; !p_text_intro nc >]
                  | 'H' -> [< 'cUT; !p_dot 3 nc; !p_text_head nc >]
                  | 'B' -> [< 'cUT; !p_dot 3 nc; !p_text_body nc >]
                  | 'C' -> [< 'cUT; !p_dot 3 nc; !p_text_concl nc >]
                  | _ -> [< >]); match nc_select_rule_family 4 nc with
                                  | 'I' ->
                                   [< 'cUT; !p_dot 4 nc; !p_text_intro nc >]
                                  | 'H' ->
                                   [< 'cUT; !p_dot 4 nc; !p_text_head nc >]
                                  | 'B' ->
                                   [< 'cUT; !p_dot 4 nc; !p_text_body nc >]
                                  | 'C' ->
                                   [< 'cUT; !p_dot 4 nc; !p_text_concl nc >]
                                  | _ -> [< >] >]
 else v' [< (match nc_select_rule_family 1 nc with
             | 'I' -> [< !p_text_intro nc >]
             | 'H' -> [< !p_text_head nc >]
             | 'B' -> [< !p_text_body nc >]
             | 'C' -> [< !p_text_concl nc >]
             | _ -> [< >]); (match nc_select_rule_family 2 nc with
                             | 'I' -> [< 'cUT; !p_text_intro nc >]
                             | 'H' -> [< 'cUT; !p_text_head nc >]
                             | 'B' -> [< 'cUT; !p_text_body nc >]
                             | 'C' -> [< 'cUT; !p_text_concl nc >]
                             | _ -> [< >]);
 (match nc_select_rule_family 3 nc with
  | 'I' -> [< 'cUT; !p_text_intro nc >]
  | 'H' -> [< 'cUT; !p_text_head nc >]
  | 'B' -> [< 'cUT; !p_text_body nc >]
  | 'C' -> [< 'cUT; !p_text_concl nc >]
  | _ -> [< >]); match nc_select_rule_family 4 nc with
                  | 'I' -> [< 'cUT; !p_text_intro nc >]
                  | 'H' -> [< 'cUT; !p_text_head nc >]
                  | 'B' -> [< 'cUT; !p_text_body nc >]
                  | 'C' -> [< 'cUT; !p_text_concl nc >]
                  | _ -> [< >] >];;

let pr_definition def =
 match def with
 | N_prooftext (str, id, nc, typ) ->
  v'
   [< !p_text_theorem str; 'sTR " : "; 'sTR (string_of_id id); 'sTR "."; 'cUT;
   !p_text_statement str; 'sTR " : "; pr_c typ; 'sTR "."; 'cUT; !p_text_proof str;
   'sTR " : "; 'cUT; !p_all nc; 'cUT; !p_text_qed str; 'cUT >]
 | N_definition (str, id, c, typ) ->
  v'
   [<
   h'
    [< !p_text_definition str; 'sTR " "; 'sTR (string_of_id id); 'sTR " : "; pr_c typ;
    'sTR "." >]; 'cUT; pr_c c; 'cUT >]
 | N_axiom (str, id, typ) ->
  v'
   [<
   h' [< !p_text_axiom str; 'sTR " "; 'sTR (string_of_id id); 'sTR " : "; pr_c typ >];
   'cUT >];;

let nc_set_pprinter_text () =
 p_dot_top:=pr_dot_top;
 p_dot_mid:=pr_dot_mid;
 p_dot_dot:=pr_dot_dot;
 p_dot:=pr_dot;
 p_indent:=pr_indent;
 p_case_number:=pr_case_number;
 p_lambda_binder_type:=pr_lambda_binder_type;
 p_nbr_cases:=pr_nbr_cases;
 p_induct_cst:=pr_induct_cst;
 p_cst:=pr_cst;
 p_fix_case_name:=pr_fix_case_name;
 p_fix_case_type:=pr_fix_case_type;
 p_type_1:=pr_type_1;
 p_type_2:=pr_type_2;
 p_type_3:=pr_type_3;
 p_type_1_bis:=pr_type_1_bis;
 p_type_2_bis:=pr_type_2_bis;
 p_type_3_bis:=pr_type_3_bis;
 p_lambda_son:=pr_lambda_son;
 p_lambda_var_list:=pr_lambda_var_list;
 p_lambda_var_list_hyp:=pr_lambda_var_list_hyp;
 p_apply_head:=pr_apply_head;
 p_apply_sub_horiz:=pr_apply_sub_horiz;
 p_apply_sub_horiz_cap:=pr_apply_sub_horiz_cap;
 p_apply_sub_horiz_expl:=pr_apply_sub_horiz_expl;
 p_elim_head:=pr_elim_head;
 p_apply_head_vert:=pr_apply_head_vert;
 p_elim_head_vert:=pr_elim_head_vert;
 p_lambda_body:=pr_lambda_body;
 p_apply_body:=pr_apply_body;
 p_elim_body:=pr_elim_body;
 p_fix_body:=pr_fix_body;
 p_misc_body:=pr_misc_body;
 p_text_intro:=pr_text_intro;
 p_text_head:=pr_text_head;
 p_text_body:=pr_text_body;
 p_text_concl:=pr_text_concl;
 p_all:=pr_all;
 p_definition:=pr_definition;;

