(**************************************************************************
  *********                    ntsons.ml                          *********
  **************************************************************************)

open Generic;;
open Std;;
open Term;;
open Vectops;;
open More_util;;
open Ntdef;;
open Ntaux;;
open Pp;;

(**************************************************************************
  *******************                 sons              *******************
  *************************************************************************
  *************************************************************************
  *********                         lambda son                    *********
  **************************************************************************)
let nc_lambda_son nc =
 match nc_get_n_i nc, nc_body nc with
 | (Ni_lambda _), (DOP2 (_, _, (DLAM (_, nc')))) -> nc'
 | _ -> error "ntsons__nc_lambda_son";;

(**************************************************************************
  *********                           apply sons                  *********
  **************************************************************************)
let nc_apply_subs nc =
 let f_aux nc =
  match nc_get_n_a nc with
  | Na_app_son (_, (Nasa_sub _), _) -> true
  | _ -> false in
 select_list_of_DOPN f_aux nc;;

let nc_apply_head nc =
 try let f_aux nc =
      match nc_get_n_a nc with
      | Na_app_son (_, Nasa_head, _) -> true
      | _ -> false in
     select_DOPN_first f_aux nc
 with
 | Not_found -> error "ntsons__nc_apply_head";;

(**************************************************************************
  *********                          elim sons                    *********
  **************************************************************************)
let nc_elim_cases nc =
 let f_aux nc =
  match nc_get_n_a nc with
  | Na_app_son (_, _, (Nase_case _)) -> true
  | _ -> false in
 select_list_of_DOPN f_aux nc;;

let nc_elim_head nc =
 let f_aux nc =
  match nc_get_n_a nc with
  | Na_app_son (_, _, (Nase_destruct _)) -> true
  | _ -> false in
 try select_DOPN_first f_aux nc
 with
 | Not_found -> error "ntsons__nc_elim_head";;

(**************************************************************************
  *********                       app sons                        *********
  **************************************************************************)
let nc_app_sons nc =
 try match nc_get_n_i nc with
  | Ni_app (_, (Nauc_apply _)) -> nc_apply_head nc::nc_apply_subs nc
  | Ni_app (_, (Nauc_elim _)) -> nc_elim_head nc::nc_elim_cases nc
  | _ -> []
 with
 | UserError ("ntsons__nc_apply_head", _)
   | (UserError ("ntsons__nc_apply_subs", _)
      | (UserError ("ntsons__nc_elim_head", _)
         | UserError ("ntsons__nc_elim_cases", _))) ->
 error "ntsons__nc_app_sons";;

(**************************************************************************
  *********                            elim one son               *********
  **************************************************************************)
let nc_elim_one_case nc =
 try match nc_elim_cases nc with
  | nc :: [] -> nc
  | _ -> error "ntsons__nc_elim_one_case"
 with
 | UserError ("ntsons__nc_elim_cases", _) -> error "ntsons__nc_elim_one_case";;

(**************************************************************************
  *********                          fix sons                     *********
  **************************************************************************)
let nc_fix_sons nc =
 let rec f_aux =
  function
     | DLAM (_, c) -> f_aux c
     | DLAMV (_, v) -> v
     | _ -> error "ntsons__nc_fix_sons" in
 try match nc_body nc with
  | DOPN ((Inl (Fix _)), v) -> Array.to_list (f_aux (last_vect v))
  | _ -> error "ntsons__nc_fix_sons"
 with
 | UserError ("ntsons__nc_fix_sons_aux", _) -> error "ntsons__nc_fix_sons";;

(**************************************************************************
  *********                          sons                         *********
  **************************************************************************)
let nc_sons nc =
 try match nc_get_n_i nc with
  | Ni_lambda _ -> [nc_lambda_son nc]
  | Ni_app _ -> nc_app_sons nc
  | Ni_fix _ -> nc_fix_sons nc
  | _ -> []
 with
 | UserError ("ntsons__nc_lambda_son", _) | UserError ("ntsons__nc_app_sons", _)
   | UserError ("ntsons__nc_fix_sons", _) -> error "ntsons__nc_sons";;

(**************************************************************************
  *******************                  sons_fun         *******************
  **************************************************************************)
let select_vect_bool_vect f v =
 let bv = Array.create (Array.length v) false in
 for i = 0 to Array.length v do bv.(i) <- f v.(i) done; bv;;

let select_vect_index_list f v =
 let il = ref [] in
 for i = Array.length v downto 0 do
   if f v.(i) then il:=i::!il
   done; !il;;

let bUG_vect_item = Array.get;;

let select_vect_fun exn f v =
 let il = select_vect_index_list f v in
 let l = List.map (bUG_vect_item v) il in
 
  (function l' -> if for_all2 (==) l l' then v
                   else begin
                    let v' = Array.copy v in
                    try List.iter2 (Array.set v') il l; v'
                    with
                    | Failure "do_list2" -> raise exn
                  end), l;;

let select_list_of_DOPN_fun exn f nc =
 let f_body, body = nc_jump_fun nc in
 match body with
  | DOPN (op, v) ->
   let f_sons, sons = select_vect_fun exn f v in
   
    (function sons' -> if try for_all2 ( (==)) sons sons'
                          with
                          | Failure "for_all2" -> raise exn then nc
                        else f_body (DOPN (op, f_sons sons))), sons
  | _ -> raise exn;;

let select_vect_first_fun f v =
 let i = first_vect f v in
 let son = v.(i) in
 
  (function son' -> if son == son' then v
                     else begin
                      let v' = Array.copy v in
                      v'.(i) <- son'; v'
                    end), son;;

let select_DOPN_first_fun exn f nc =
 let f_body, body = nc_jump_fun nc in
 match body with
  | DOPN (op, v) ->
   let f_son, son = select_vect_first_fun f v in
   
    (function son' -> if son == son' then nc
                       else f_body (DOPN (op, f_son son'))), son
  | _ -> raise exn;;

(**************************************************************************
  *********                         lambda son fun                *********
  **************************************************************************)
let nc_lambda_son_fun nc =
 let f_body, body = nc_jump_fun nc in
 match body with
  | DOP2 (op, typ, (DLAM (na, nc'))) -> 
                                         (function son -> if son == nc' then nc
                                                           else
                                                           f_body
                                                           (DOP2
                                                           (op, typ,
                                                           DLAM (na, son)))),
                                         nc'
  | _ -> error "ntsons__nc_lambda_son_fun";;

(**************************************************************************
  *********                           apply sons fun              *********
  **************************************************************************)
let nc_apply_subs_fun nc =
 let f_aux nc =
  match nc_get_n_a nc with
  | Na_app_son (_, (Nasa_sub _), _) -> true
  | _ -> false in
 select_list_of_DOPN_fun
  (UserError ("ntsons__nc_apply_subs_fun", [< 'sTR "ntsons__nc_apply_subs_fun" >]))
  f_aux nc;;

let nc_apply_head_fun nc =
 try let f_aux nc =
      match nc_get_n_a nc with
      | Na_app_son (_, Nasa_head, _) -> true
      | _ -> false in
     select_DOPN_first_fun
      (UserError
      ("ntsons__nc_apply_head_fun", [< 'sTR "ntsons__nc_apply_head_fun" >])) f_aux
      nc
 with
 | Not_found -> error "ntsons__nc_apply_head_fun";;

(**************************************************************************
  *********                          elim sons fun                *********
  **************************************************************************)
let nc_elim_cases_fun nc =
 let f_aux nc =
  match nc_get_n_a nc with
  | Na_app_son (_, _, (Nase_case _)) -> true
  | _ -> false in
 select_list_of_DOPN_fun
  (UserError ("ntsons__nc_elim_cases_fun", [< 'sTR "ntsons__nc_elim_cases_fun" >]))
  f_aux nc;;

let nc_elim_head_fun nc =
 let f_aux nc =
  match nc_get_n_a nc with
  | Na_app_son (_, _, (Nase_destruct _)) -> true
  | _ -> false in
 try
  select_DOPN_first_fun
  (UserError ("ntsons__nc_elim_head_fun", [< 'sTR "ntsons__nc_elim_head_fun" >]))
  f_aux nc
 with
 | Not_found -> error "ntsons__nc_elim_head_fun";;

(**************************************************************************
  *********                           app sons fun                *********
  **************************************************************************)
let nc_app_sons_fun nc =
 match nc with
 | DOP1 ((Inr ({n_i=Ni_app (_, (Nauc_apply _))})), _) ->
  let f_aux nc =
   match nc_get_n_a nc with
   | Na_app_son (_, Nasa_head, _) -> true
   | Na_app_son (_, (Nasa_sub _), _) -> true
   | _ -> false in
  select_list_of_DOPN_fun
   (UserError ("ntsons__nc_app_sons_fun", [< 'sTR "ntsons__nc_app_sons_fun" >]))
   f_aux nc
 | DOP1 ((Inr ({n_i=Ni_app (_, (Nauc_elim _))})), _) ->
  let f_aux nc =
   match nc_get_n_a nc with
   | Na_app_son (_, _, (Nase_destruct _)) -> true
   | Na_app_son (_, _, (Nase_case _)) -> true
   | _ -> false in
  select_list_of_DOPN_fun
   (UserError ("ntsons__nc_app_sons_fun", [< 'sTR "ntsons__nc_app_sons_fun" >]))
   f_aux nc
 | _ -> error "ntsons__nc_app_sons_fun";;

(**************************************************************************
  *********                            elim one sons fun          *********
  **************************************************************************)
let nc_elim_one_case_fun nc =
 try match nc_elim_cases_fun nc with
  | f_sons, (son :: []) -> 
                            (function son -> f_sons [son]), son
  | _ -> error "ntsons__nc_elim_one_case_fun"
 with
 | UserError ("ntsons__nc_elim_cases_fun", _) ->
 error "ntsons__nc_elim_one_case_fun";;

(**************************************************************************
  *********                          fix sons fun                 *********
  **************************************************************************)
let nc_fix_sons_fun nc =
 let rec f_aux =
  function
     | DLAM (na, c) ->
      let f_l, l = f_aux c in
      
       (function l -> DLAM (na, f_l l)), l
     | DLAMV (na, v) -> 
                         (function l -> DLAMV (na, Array.of_list l)),
                         Array.to_list v
     | _ -> error "ntsons__nc_fix_sons_fun" in
 let f_body, body = nc_jump_fun nc in
 match body with
  | DOPN ((Inl (Fix _) as op), v) ->
   let i = Array.length v - 1 in
   let f_sons, sons = f_aux v.(i) in
   
    (function sons ->
     let v' = Array.copy v in
     v'.(Array.length v - 1) <- f_sons sons; f_body (DOPN (op, v'))), sons
  | _ -> error "ntsons__nc_fix_sons_fun";;

(**************************************************************************
  *********                          sons fun                     *********
  **************************************************************************)
let nc_sons_fun nc =
 try match nc_get_n_i nc with
  | Ni_lambda _ ->
   let f_son, son = nc_lambda_son_fun nc in
   
    (function
        | son :: [] -> f_son son
        | _ -> error "ntsons__nc_sons_fun"), [son]
  | Ni_app _ ->
   let f_sons, sons = nc_app_sons_fun nc in
   
    (function sons -> begin
      try f_sons sons
      with
      | UserError ("ntsons__nc_app_sons_fun", _) -> error "ntsons__nc_sons_fun"
    end), sons
  | Ni_fix _ ->
   let f_sons, sons = nc_fix_sons_fun nc in
   
    (function sons -> begin
      try f_sons sons
      with
      | UserError ("ntsons__nc_fix_sons_fun", _) -> error "ntsons__nc_sons_fun"
    end), sons
  | _ -> 
          (function
              | [] -> nc
              | _ -> error "ntsons__nc_sons_fun"), []
 with
 | UserError ("ntsons__nc_lambda_son_fun", _)
   | UserError ("ntsons__nc_app_sons_fun", _)
   | UserError ("ntsons__nc_fix_sons_fun", _) -> error "ntsons__nc_sons_fun";;

(**************************************************************************
  *******************             rec_sons              *******************
  *************************************************************************
  *************************************************************************
  *********                        apply rec sons                 *********
  **************************************************************************)
let rec nc_rec_apply_subs nc =
 let f_aux nc =
  match nc_get_n_a nc with
  | Na_app_son (_, (Nasa_sub (recur, _)), _) -> if recur = None then [nc]
                                                 else nc_rec_apply_subs nc
  | _ -> [] in
 flat_map_list_of_DOPN f_aux nc;;

(**************************************************************************
  *********                         elim rec sons                 *********
  **************************************************************************)
let rec nc_rec_elim_cases nc =
 let f_aux nc =
  match nc_get_n_a nc with
  | Na_app_son (_, _, (Nase_case (recur, _, _, _, _))) ->
   if recur then nc_rec_elim_cases (nc_lambda_son nc)
    else [nc]
  | _ -> [] in
 flat_map_list_of_DOPN f_aux nc;;

(**************************************************************************
  *********                         elim one rec son              *********
  **************************************************************************)
let rec nc_rec_elim_one_case nc =
 try match nc_rec_elim_cases nc with
  | nc :: [] -> nc
  | _ -> error "ntsons__nc_rec_elim_one_case"
 with
 | UserError ("ntsons__nc_rec_elim_cases", _) ->
 error "ntsons__nc_rec_elim_one_case";;

(**************************************************************************
  *********                            app rec sons               *********
  **************************************************************************)
let rec nc_rec_app_sons nc =
 try match nc_get_n_i nc with
  | Ni_app (_, (Nauc_apply _)) -> nc_apply_head nc::nc_rec_apply_subs nc
  | Ni_app (_, (Nauc_elim _)) -> nc_elim_head nc::nc_rec_elim_cases nc
  | _ -> []
 with
 | UserError ("ntsons__nc_apply_head", _)
   | (UserError ("ntsons__nc_rec_apply_subs", _)
      | (UserError ("ntsons__nc_elim_head", _)
         | UserError ("ntsons__nc_rec_elim_cases", _))) ->
 error "ntsons__nc_rec_app_sons";;

(**************************************************************************
  *********                     rec sons                          *********
  **************************************************************************)
let nc_rec_sons nc =
 try match nc_get_n_i nc with
  | Ni_lambda _ -> [nc_lambda_son nc]
  | Ni_app _ -> nc_rec_app_sons nc
  | Ni_fix _ -> nc_fix_sons nc
  | _ -> []
 with
 | UserError ("ntsons__nc_lambda_son", _)
   | UserError ("ntsons__nc_rec_app_sons", _)
   | UserError ("ntsons__nc_fix_sons", _) -> error "ntsons__nc_rec_sons";;

(**************************************************************************
  *************************************************************************
  *************************************************************************
  **************************************************************************)
let nc_do_to_sons f nc = List.iter f (nc_sons nc);;

let rec nc_do_top_down f nc =
 f nc; nc_do_to_sons (nc_do_top_down f) nc;;

let rec nc_do_down_top f nc =
 nc_do_to_sons (nc_do_down_top f) nc;
 f nc;
 ();;

(***************************************************************************)
let nc_app_to_sons f nc =
 let f_sons, sons = nc_sons_fun nc in
 let sons' = List.map (function nc -> nc, f nc) sons in
 if List.for_all (function a, b -> a == b) sons' then nc
  else f_sons (List.map snd sons');;

let rec nc_app_top_down f nc =
 let nc' = f nc in
 nc_app_to_sons (nc_app_top_down f) nc';;

let rec nc_app_down_top f nc =
 let nc' = nc_app_to_sons (nc_app_down_top f) nc in
 f nc;; (**)

