(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                fwtoml.mli                                *)
(****************************************************************************)

open Proof_trees;;
open Evd;;

val lOOSE_EXTRACTION : bool ref
val loose_extraction : unit -> bool
val set_loose : bool -> unit
val cofix : bool ref
val execute :
  evar_declarations ->
  Term.environment -> Term.constr -> Term.judgement

type packet_info =
  { pACKET_name: Names.identifier;
    pACKET_ncons: int;
    pACKET_cnames: Names.identifier array;
    pACKET_arities: int array }

val mind_table : (Names.section_path * int, packet_info) Hashtabl.t
val reset_mind_table : unit -> unit
val store_mind_info : Names.section_path * int -> packet_info -> unit
val get_mind_info : Names.section_path * int -> packet_info

type renaming_function =
  Names.identifier list -> Names.name -> Names.identifier

module type RENAMING =
  sig
    val rename_type_parameter : renaming_function
    val rename_type : renaming_function
    val rename_term : renaming_function
    val rename_global_type : renaming_function
    val rename_global_constructor : renaming_function
    val rename_global_term : renaming_function
  end

val globals_renaming : (Names.identifier * Names.identifier) list ref
val globals : Names.identifier list ref
val reset_globals_renaming : unit -> unit
val add_global_renaming : Names.identifier * Names.identifier -> unit
val get_global_name : Names.identifier -> Names.identifier
val name_of_oper : Term.sorts Term.oper -> Names.identifier

module type TRANSLATION = 
    sig
      val ren_type_parameter :
        Names.identifier list -> Names.name -> Names.identifier
      val ren_type : Names.identifier list -> Names.name -> Names.identifier
      val ren_term : Names.identifier list -> Names.name -> Names.identifier
      val ren_global_type : Names.identifier -> Names.identifier
      val ren_global_constructor : Names.identifier -> Names.identifier
      val ren_global_term : Names.identifier -> Names.identifier
      val mltype_of_constr :
        Mlterm.typeid list -> Term.constr -> Mlterm.mLtype
      val isSet : Term.sorts Term.oper Generic.term -> bool
      val abbrev_of_constr :
        Term.constr -> Names.identifier list * Mlterm.mLtype
      val type_of_c :
        Mlterm.typeid list ->
        Term.environment ->
        Mlterm.mLtype list ->
        Term.sorts Term.oper Generic.term -> Mlterm.mLtype list
      val decl_of_one_inductive :
        Names.section_path * int ->
        Term.environment ->
        int ->
        Constrtypes.mutual_inductive_packet ->
        Names.identifier list * Names.identifier *
        (Names.identifier * Mlterm.mLtype list) list
      val decl_of_inductive :
        Names.section_path ->
        Constrtypes.mutual_inductive_body -> Mlterm.mLdecl
      val collect_n_lambda :
        int -> Mlterm.mLast -> Names.identifier list * int * Mlterm.mLast
      val mlast_of_constr :
        Names.identifier list ->
        Term.environment ->
        Mlterm.mLast list -> Term.constr -> Mlterm.mLast
      val mlast_of_fix :
        bool ->
        Names.identifier list ->
        Term.environment -> bool -> Term.constr -> Mlterm.mLast
      val mlpat_of_constr :
        Names.identifier list ->
        Names.section_path * int ->
        Mlterm.mLast array ->
        (Names.identifier * Names.identifier list * Mlterm.mLast) array
      val is_rec : 'a Term.oper Generic.term -> bool
      val axiom_type_msg : Names.identifier -> 'a
      val not_an_ML_type_msg : Names.identifier -> 'a
      val decl_of_constant :
        'a ->
        Names.section_path -> Constrtypes.constant_body -> Mlterm.mLdecl
      val decl_of_sp : 'a -> Names.section_path -> Mlterm.mLdecl
      val mlenv_of_fwenv :
        'a * bool -> Names.section_path list -> Mlterm.mLdecl list
    end

module Mlenv_of_fwenv : functor(R : RENAMING) -> TRANSLATION

(* $Id: fwtoml.mli,v 1.6 1999/08/06 20:49:20 herbelin Exp $ *)
