(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 Mimick.v                                 *)
(****************************************************************************)

Declare ML Module "Mimick".

Grammar vernac vernac :=
  write_mimick [ "Write" "Mimick" prim:string($s) "." ] -> [(WriteMimick $s)]
| show_mimick  [ "Show" "Mimick" "." ] -> [(ShowMimick)].

Grammar tactic simple_tactic :=
  mimick [ "Mimick" prim:string($s) ] -> [(Mimick $s)]
| mimic_tac [ "Tactic" "Mimick" prim:string($s) ] -> [(TacticMimick $s)]
| dump_mimick [ "Mimick" ] -> [(DumpMimick)]
| dump_mimick_tac [ "Tactic" "Mimick" ] -> [(DumpTacticMimick)]
| mimick_with [ "Mimick" identarg($id) ] -> [(DumpMimickWith $id)]
| mimick_tac_with [ "Tactic" "Mimick" identarg($id) ]
                   -> [(DumpTacticMimickWith $id)].

Syntax tactic level 0:
  mimick [(Mimick ($STR $s))] -> ["Mimick " $s]
| idmimick [(TacticMimick ($STR $s))] -> ["Mimick " $s].



(* Show Mimick ==> shows the script of tactics that were reused by
                   the tactic Mimick.

   Write Mimick "toto".  ==> writes the current script of the proof
                           to the file $MIMICKDIR/toto.pf.
                           The (possibly incomplete) proof in toto.pf
                           may be replayed using Mimick "toto".


   Mimick "toto".  ==> Looks for file toto.pf in the directory $MIMICK and tries to mimick 
                       it.

   Mimick.  ==> If "toto" is the name of the current theorem, it looks for the file
                #toto.obj.pf in the directory $MIMICK.

   Tactic Mimick  ==> " will mimick a proof, and whenever a step fails to
    produce children which are equal to the ones in the original
    proof, it will revert to the proof which is behind the current
    proof, failing if it doesn't find such a proof.
    The rules which we can handle are PRIM, CONTEXT, and TACTIC.  The
    others cause immediate failure." (Chet)

    It seems to always fail in practice.

One the proof of the theorem "toto" is saved with Qed, the proof to be mimicked is
saved in the direcory $MIMICKDIR with name #toto.obj.pf. 


Example : 

Theorem firstheo : (A,B:Prop)(A/\B)->A\/B.
(Intros A B H;Case H;Intros).
Try Right.
Assumption.
Qed.

Theorem secondtheo : (A,B:Prop)(A/\B)->A.
Mimick firstheo.
Assumption.
Qed.


Note the difference with respect to :

Theorem firstheo : (A,B:Prop)(A/\B)->A\/B.
(Intros A B H;Case H;Intros;Try Right;Assumption).
Qed.

Theorem secondtheo : (A,B:Prop)(A/\B)->A.
Mimick firstheo.
Qed.

where the tactic succeeds in replaying the whole proof.

--Eduardo Gimenez (21/3/97

*)


(* $Id: Mimick.v,v 1.9 1999/06/29 07:47:57 loiseleu Exp $ *)
