(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                EqDecide.v                                *)
(*     A tactic for deciding propositional equality on inductive types      *)
(*                             by Eduardo Gimenez                           *)
(****************************************************************************)

Declare ML Module "equality" "eqdecide".


Grammar tactic simple_tactic :=
  EqDecideRuleG1 
       [ "Decide"  "Equality" comarg($com1)  comarg($com2)] -> 
       [(DecideEquality $com1 $com2)]

| EqDecideRuleG2 
       [ "Decide" "Equality"  ] -> [(DecideEquality)]

| CompareRule 
       [ "Compare" comarg($com1) comarg($com2)] -> 
       [(Compare $com1 $com2)].


Syntax tactic level 0:
  EqDecideRulePP1 [(DecideEquality)] -> ["Decide Equality"]

| EqDecideRulePP2 
       [(DecideEquality $com1 $com2)]    -> 
       ["Decide Equality" [1 2] $com1 [1 2] $com2]

| ComparePP 
       [(Compare $com1 $com2)]    -> 
       ["Compare" [1 2] $com1 [1 2] $com2].

