(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               termenv.mli                                *)
(****************************************************************************)

open Names
open Term
open Constrtypes
open Evd

(* Variables *)

val initial_sign : unit -> context;;
val initial_fsign : unit -> context;;
val initial_assumptions :
  unit -> context * context;;
val initial_sigma_sign : unit -> 'a evar_map * context
val initial_sigma_assumptions :
  unit -> 'a evar_map * (context * context)

val auto_save_variables : unit -> identifier list

(* Three kinds of existential/meta-variables: Meta, evar, isevar *)

val newMETA : unit -> int;;
val new_evar_path : path_kind -> section_path
val new_isevar_path : path_kind -> section_path

val evar_of_id : path_kind -> identifier -> section_path
val mkNewMeta      : unit -> constr

val is_existential_id : identifier -> bool
val is_existential : constr -> bool
val is_existential_oper : sorts oper -> bool

val occur_existential : constr -> bool
val defined_existential : 'c evar_map -> constr -> bool

(* For global constants only *)

val defined_constant  : constr -> bool
val has_ise           : constr -> bool

(* For global or local constants *)

val const_value       : 'c evar_map -> constr -> constr
val evaluable_const   : 'c evar_map -> constr -> bool
val cookable_constant : section_path -> bool
val opaque_const      : 'c evar_map -> constr -> bool
val translucent_const : 'c evar_map -> constr -> bool
val defined_const     : 'c evar_map -> constr -> bool
val const_type        : 'c evar_map -> constr -> constr

type mind_specif = 
{sp:section_path;
 mib:mutual_inductive_body;
 tyi:int;
 args:constr array;
 mip:mutual_inductive_packet}

val mis_arity        : mind_specif -> constr
val mis_lc           : mind_specif -> constr
val mis_lc_arity     : mind_specif -> constr * constr
val mis_lc_without_abstractions : mind_specif -> constr array
val mis_kd           : mind_specif -> sorts list
val mis_kn           : mind_specif -> sorts list
val mis_lamexp       : mind_specif -> constr option
val mis_nparams      : mind_specif -> int
val mis_ntypes       : mind_specif -> int
val mis_consnames    : mind_specif -> identifier array
val mis_nconstr      : mind_specif -> int
val mis_singl        : mind_specif -> constr option
val mis_typename     : mind_specif  -> identifier
val mis_recargs      : mind_specif -> (recarg list) array array
val mis_recarg       : mind_specif -> (recarg list) array
val mis_is_recursive : mind_specif -> bool
val mis_is_finite    : mind_specif -> bool

val is_singl : section_path -> bool

val mind_specif_of_mind : constr -> mind_specif

val mind_path         : constr -> section_path
val mind_arity        : constr -> constr
val mind_is_finite    : constr -> bool
val mind_lamexp       : constr -> constr option
val mind_recargs      : constr -> recarg list array array
val mind_is_recursive : constr -> bool
val mind_nparams      : constr -> int
val mindsp_nparams    : section_path -> int



(* Abstractions *)
val abst_value : constr -> constr
val global_abst : section_path -> constr array -> constr
val search_abst : path_kind -> identifier -> constr array -> constr
val evaluable_abst : constr -> bool
val translucent_abst : constr -> bool

val mconstr_implicits : constr -> int list
val mind_implicits : constr -> int list
val constant_implicits : constr -> int list

(* Constants and abstractions *)
val const_abst_opt_value : 'c evar_map -> constr -> constr option

val new_name_from_type : identifier -> constr -> identifier

(* $Id: termenv.mli,v 1.11 1999/08/06 20:49:17 herbelin Exp $ *)
