(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               dischcore.ml                               *)
(****************************************************************************)

open Std;;
open Names;;
open Generic;;
open Term;;
open Reduction;;
open Typing;;
open Pp;;
open Himsg;;
open Constrtypes;;
open Environ;;
open Termenv;;

let thin_hyps_glob init_globs (hyps,globals) =
  let vars = init_globs@globals in
    rev_sign(fst(it_sign (fun ((hyps,globs) as sofar) id a ->
                         if List.mem id globs then
                             (add_sign (id,a) hyps,(global_vars a.body)@globs)
                         else sofar) (nil_sign,vars) hyps))
;;

let thin_hyps init_globs (hyps,j) =
  thin_hyps_glob init_globs (hyps,global_vars(DOPN(AppL,[|j._VAL;j._TYPE|])))

let thin_to_match sign fsign =
    sign_it (fun id ty fsign ->
                 if mem_sign sign id then
                     (add_sign (id,ty) fsign)
                 else fsign)
    fsign nil_sign
;;

let rec thin_to_level fsign k =
    if isnull_sign fsign then nil_sign
    else if k=mkImplicit then fsign 
    else let (na,t),tls = uncons_sign fsign in let s = DOP0 (Sort t.typ)
         in if s=mkImplicit or (le_kind k s) then
             add_sign (na,t) (thin_to_level tls k)
            else thin_to_level tls k
;;

let rec thin_to_type_level fsign =
    if isnull_sign fsign then nil_sign
    else let (na,t),tls = uncons_sign fsign
         in match t.typ with
		Type _ -> add_sign (na,t) (thin_to_type_level tls)
              | _ -> thin_to_type_level tls
;;

let expmod_constr modlist c =
  let sigma = Evd.mt_evd() in
  let simpfun = if modlist = [] then fun x -> x else nf_betaiota in
  let expfun c = 
    let (sp,_) = destConst c in 
      if not(cookable_constant sp) then
      	anomaly "expmod_constr: an uncookable constant was discharged";
      try const_value sigma c
      with Failure _ as e ->
      	(mSGERRNL 
	   [< 'sTR"Cannot unfold the value of " ;
              'sTR(string_of_path sp) ; 'sPC;
              'sTR"You cannot declare local lemmas as being opaque"; 'sPC;
              'sTR"and then require that theorems which use them"; 'sPC;
              'sTR"be transparent" >];
	 (snd (const_of_path sp)).cONSTOPAQUE <- false;
	 (try
           let v = const_value sigma c
           in ((snd (const_of_path sp)).cONSTOPAQUE <- true; v)
	  with _ -> anomaly "expmod_constr")) in

  let under_casts f = function
      (DOP2(Cast,c,t)) -> (DOP2(Cast,f c,f t))
    | c -> f c in
  let c' = modify_opers expfun (fun a b -> mkAppL [|a; b|]) modlist c in
    match c' with
    	DOP2(Cast,val_0,typ) -> DOP2(Cast,simpfun val_0,simpfun typ)
      | DOP2(XTRA("IND",[]),c,DLAMV(na,lc)) ->
	  DOP2(XTRA("IND",[]),under_casts simpfun c,
               DLAMV(na,Array.map (under_casts simpfun) lc))
      | _ -> simpfun c'
;;

let expmod_type modlist {body=c;typ=s} = {body=expmod_constr modlist c;typ=s}

(* $Id: dischcore.ml,v 1.11 1999/08/06 20:49:13 herbelin Exp $ *)
