(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               tactics0.mli                               *)
(****************************************************************************)

open Names
open Term
open Generic
open Clenv
open Tacmach
open Proof_trees
open Evd

val pf_get_new_id    : identifier      -> goal sigma   -> identifier
val pf_get_new_ids   : identifier list -> goal sigma   -> identifier list

type arg_binder   = DEP of identifier | NODEP of int | ABS of int
type arg_bindings = (arg_binder * constr) list

val clenv_constrain_with_bindings :
  arg_bindings ->
  walking_constraints clausenv ->
  walking_constraints clausenv


val add_prod_rel :
  'a evar_map -> constr * environment -> constr * environment
val add_prods_rel :
  'a evar_map -> constr * environment -> constr * environment

val add_prod_sign :
  'a evar_map ->
    constr * context -> constr * context

val add_prods_sign :
  'a evar_map ->
  constr * context -> constr * context


val res_pf_THEN         : (walking_constraints -> tactic) -> 
                           walking_constraints clausenv -> 
                          (walking_constraints clausenv -> tactic) -> tactic;;
val res_pf_THEN_i       : (walking_constraints -> tactic) -> 
                           walking_constraints clausenv -> 
                          (walking_constraints clausenv -> int -> tactic) -> 
                           int -> tactic;;
val elim_res_pf_THEN_i  : (walking_constraints -> tactic) -> 
                           walking_constraints clausenv -> 
                          (walking_constraints clausenv -> int -> tactic) -> 
                            int -> tactic;;
val mk_clenv_using      : walking_constraints -> constr -> 
                                     walking_constraints clausenv;;
val applyUsing          : constr -> tactic;;
val clenv_apply_n_times : int -> walking_constraints clausenv -> 
                          walking_constraints clausenv;;

