(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                              tacinterp.mli                               *)
(****************************************************************************)

open Names
open Proof_trees
open Pp
open Tacmach
open Term

val tactic_tab           : (string, tactic_arg list -> tactic) Mhm.t
val tacinterp_add        : string * (tactic_arg list -> tactic) -> unit
val tacinterp_map        : string -> tactic_arg list -> tactic
val tacinterp_init       : unit -> unit
val interp               : CoqAst.t -> tactic
val interp_atomic        : CoqAst.loc -> string -> tactic_arg list -> tactic
val interp_semi_list     : tactic -> CoqAst.t list -> tactic
val vernac_interp        : CoqAst.t -> tactic;;
val vernac_interp_atomic : identifier -> tactic_arg list -> tactic;;
val overwriting_tacinterp_add : string * (tactic_arg list -> tactic) -> unit
val is_just_undef_macro     : CoqAst.t -> string option;;

(* $Id: tacinterp.mli,v 1.7 1999/06/29 07:47:34 loiseleu Exp $ *)
