(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                names.mli                                 *)
(****************************************************************************)

open Pp

type identifier
type name = Name of identifier | Anonymous

val make_ident : string -> int -> identifier
val repr_ident : identifier -> string * int
val lift_ident : identifier -> identifier

val next_ident_away_from : identifier -> identifier list -> identifier
val next_ident_away : identifier -> identifier list -> identifier
val next_name_away : name -> identifier list -> identifier
val next_name_away_with_default : string -> name -> identifier list -> identifier
val get_new_ids : int -> identifier -> identifier list -> identifier list

val explode_id : identifier -> string list
val print_id   : identifier -> std_ppcmds
val pr_idl     : identifier list -> std_ppcmds
val string_of_id : identifier -> string
val id_of_string : string -> identifier
val atompart_of_id : identifier -> string
val index_of_id : identifier -> int
val id_ord : identifier -> identifier -> int
val id_without_number : identifier -> bool

type path_kind = CCI | FW | OBJ
val string_of_kind : path_kind -> string
val kind_of_string : string -> path_kind
val assoc_kind : path_kind -> (path_kind * 'a) list -> 'a

type section_path

val make_path : string list -> identifier -> path_kind -> section_path
val repr_path : section_path -> string list * identifier * path_kind

val kind_of_path : section_path -> path_kind
val fwsp_of_ccisp : section_path -> section_path
val ccisp_of_fwsp : section_path -> section_path
val coerce_path : path_kind -> section_path -> section_path
val fwsp_of : section_path -> section_path
val ccisp_of : section_path -> section_path
val objsp_of : section_path -> section_path
val sp_ord : section_path -> section_path -> int
val sp_gt : section_path * section_path -> bool
val string_of_path : section_path -> string
val string_of_path_mind : section_path -> identifier -> string
val path_of_string : string -> section_path
val basename : section_path -> identifier
val dirpath : section_path -> string list
val append_to_path : section_path -> string -> section_path


(* TODO: ranger (provient de Ast) *)
val section_path : string list -> string -> section_path
val path_section : CoqAst.loc -> section_path -> CoqAst.t



val sp_of_wd : string list -> section_path

type 'a signature = identifier list * 'a list
type 'a db_signature = (name * 'a) list
type ('a,'b) env = ENVIRON of 'a signature * 'b db_signature

val nil_sign : 'a signature
val rev_sign : 'a signature -> 'a signature
val map_sign_typ : ('a -> 'b) -> 'a signature -> 'b signature
val isnull_sign : 'a signature -> bool
val hd_sign : 'a signature -> identifier * 'a
val tl_sign : 'a signature -> 'a signature

val sign_it : (identifier -> 'a -> 'b -> 'b) -> 'a signature -> 'b -> 'b
val it_sign : ('b -> identifier -> 'a -> 'b) -> 'b -> 'a signature -> 'b
val concat_sign : 'a signature -> 'a signature -> 'a signature
val add_sign : (identifier * 'a) -> 'a signature -> 'a signature
val dbenv_it : (name -> 'b -> 'c -> 'c) -> ('a,'b) env -> 'c -> 'c
val it_dbenv : ('c -> name -> 'b -> 'c) -> 'c -> ('a,'b) env -> 'c
val gLOB : 'b signature -> ('b,'a) env
val get_globals : ('b,'a) env -> 'b signature
val get_rels : ('b,'a) env -> 'a db_signature
val ids_of_sign : 'a signature -> identifier list
val vals_of_sign : 'a signature -> 'a list
val add_rel : (name * 'a) -> ('b,'a) env -> ('b,'a) env 
val add_glob : (identifier * 'b) -> ('b,'a) env -> ('b,'a) env
type ('b,'a) search_result =
    GLOBNAME of identifier  * 'b
  | RELNAME of int * 'a


val lookup_glob : identifier -> ('b,'a) env -> (identifier * 'b)
val mem_glob    : identifier -> ('b,'a) env -> bool
val lookup_rel : int -> ('b,'a) env  -> (name * 'a)
val lookup_id : identifier -> ('b,'a) env -> ('b,'a) search_result
val map_rel_env : ('a -> 'b) -> ('c,'a) env -> ('c,'b) env
val map_var_env : ('c -> 'b) -> ('c,'a) env -> ('b,'a) env
val nth_sign : 'a signature -> int -> (identifier * 'a)
val map_sign_graph : (identifier -> 'a -> 'b) -> 'a signature -> 'b list
val list_of_sign : 'a signature -> (identifier * 'a) list
val make_sign    : (identifier * 'a) list -> 'a signature
val do_sign : (identifier -> 'a -> unit) -> 'a signature -> unit
val uncons_sign : 'a signature -> (identifier * 'a) * 'a signature
val lookup_sign : identifier -> 'a signature -> (identifier * 'a)
val sign_length : 'a signature -> int
val mem_sign    : 'a signature -> identifier -> bool
val modify_sign : identifier -> 'a -> 'a signature -> 'a signature

val add_envp_rel : (name * 'a * 'b) -> ('c,'a) env * ('d,'b) env -> ('c,'a) env * ('d,'b) env

val isnull_rel_env : ('a,'b) env -> bool
val uncons_rel_env : ('a,'b) env -> (name * 'b) * ('a,'b) env
val exists_sign : (identifier -> 'a -> bool) -> 'a signature -> bool
val witness_sign : (identifier -> 'a -> bool) -> 'a signature -> (identifier*'a) 
val sign_prefix : identifier -> 'a signature -> 'a signature
val add_sign_after : identifier -> (identifier * 'a) -> 'a signature -> 'a signature
val add_sign_replacing : identifier -> (identifier * 'a) -> 'a signature -> 'a signature
val prepend_sign : 'a signature -> 'a signature -> 'a signature

module Spset : Set.S with type elt = section_path

val ids_of_env : ('a, 'b) env -> identifier list

(* Hash-consing *)
val hcons_names: unit ->
  (section_path -> section_path) * (section_path -> section_path) *
  (name -> name) * (identifier -> identifier) * (string -> string)


(* $Id: names.mli,v 1.18 1999/06/29 07:47:26 loiseleu Exp $ *)
