(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               library.mli                                *)
(****************************************************************************)

open Pp
open Names
open Libobject

(* Adding objects in the current section *)
val with_heavy_rollback : ('a -> 'b) -> ('a -> 'b)
val cwd : unit -> string list
val add_anonymous_object : obj -> unit
val add_named_object : (identifier * path_kind) -> obj -> unit

(* Modules *)
val open_section : string -> unit
val open_module : string -> unit
val close_module : section_path -> (section_path * Lib.node) list -> unit
val require_module : bool option -> string -> string option -> bool -> unit
val read_module : string -> string option -> unit
val extern_module : bool -> string -> string option -> unit

val raw_reset_section : string -> unit
val reset_keeping : identifier -> unit
val reset_to : identifier -> unit

(* various sync functions used in states and pfedit *)
val backtrack_caches : unit -> unit
val force_freeze_caches : unit -> unit
val reset_library : unit -> unit

val search_modules : unit -> (string * section_path) list
val search_imports : unit -> section_path list
val fmt_module_state : unit -> std_ppcmds

(* very low level functions. used by searchisos and a few others. *)
val lookup_module : string -> section_path
val module_is_known : string -> bool
val module_is_read : section_path -> bool
val needed_modules : Lib.node -> section_path list
val disk_intern_module : bool -> string -> section_path * Lib.node
val import_export_module : string -> bool -> unit
val spec_on_path : bool option -> string -> bool

(* This exception is raised by find_dir when the dir is not found *)
exception Unknown_dir
val find_dir : string option -> section_path
val find_nearest_module : unit -> section_path
val find_nearest_section : unit -> section_path
val is_section_p : section_path -> bool
val is_module_p : section_path -> bool

(* $Id: library.mli,v 1.14 1999/10/29 23:19:13 barras Exp $ *)
