(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                              libobject.mli                               *)
(****************************************************************************)

open Names

type obj

val object_tag : obj -> string

(* given the object-name, the "caching" function, and the "spec"
 * function, this function
 * will hand back two functions, the "injection" and "projection"
 * functions for dynamically typed library-objects.
 *)

type 'a object_declaration =
    {load_function : ('a -> unit);
     cache_function : (section_path * 'a -> unit);
     specification_function : 'a -> 'a}

val declare_object : (string * 'a object_declaration)
                    -> ('a -> obj) * (obj -> 'a)

val load_object : obj -> unit

val cache_object : (section_path * obj) -> unit

val extract_object_specification : obj -> obj

(* $Id: libobject.mli,v 1.9 1999/06/29 07:47:26 loiseleu Exp $ *)
