(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 mhs.mli                                  *)
(****************************************************************************)

type ('a,'b) t;;
type ('a,'b) frozen_t;;

(* All destructive operations below are only allowed when the local-push
 * stack is empty
 *)

val create : (int * ('b -> 'b -> int) option) -> ('a,'b) t;;
val empty : ('a,'b) t -> unit;;
val map : ('a,'b) t -> 'a -> 'b list;;
val add : ('a,'b) t -> 'a * 'b -> unit;;
val rmv : ('a,'b) t -> 'a * 'b -> unit;;
val app : (('a * 'b list) -> 'c) -> ('a,'b) t -> unit;;
val in_dom : ('a,'b) t -> 'a -> bool;;
val dom : ('a,'b) t -> 'a list;;
val toList : ('a,'b) t -> ('a * 'b list) list;;

(*
value remap : ('a,'b) t -> 'a -> 'b -> unit;;
value rng : ('a,'b) t -> 'b list;;
value inv : ('a,'b) t -> 'b -> 'a list;;
*)

val freeze : ('a,'b) t -> ('a,'b) frozen_t;;
val unfreeze : ('a,'b) frozen_t -> ('a,'b) t -> unit;;

(* the option on "pop" is so that we can ask to check
 * that what we are popping is what we originally pushed,
 * to assure that we are not by chance out of sync.
 *)
val push : ('a,'b) t -> 'a * 'b -> unit;;
val pop : ('a,'b) t -> 'a option -> unit;;
val pop_all : ('a,'b) t -> unit;;



(* $Id: mhs.mli,v 1.6 1999/06/29 07:47:19 loiseleu Exp $ *)
