(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                intavs.mli                                *)
(****************************************************************************)

type t;;

val add : t -> int -> t;;
val rmv : t -> int -> t;;
val memb : t -> int -> bool;;
val intersect : t -> t -> t;;
val union : t -> t -> t;;
val diff : t -> t -> t;;
val symdiff : t -> t -> t;;
val subset : t -> t -> bool;;
val equal : t -> t -> bool;;
val mt : t;;
val exists : (int -> bool) -> t -> bool;;
val toList : t -> int list;;
val ofList : int list -> t;;
val is_empty : t -> bool;;

(* $Id: intavs.mli,v 1.5 1999/06/29 07:47:17 loiseleu Exp $ *)
