(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                fmavm.mli                                 *)
(****************************************************************************)

type ('a,'b) t = ('a,'b) Mavm.t * ('a,'b) Mhm.t;;
type ('a,'b) frozen_t = ('a,'b) Mavm.frozen_t;;

val create : ('a -> 'a -> int) * int -> ('a,'b) t;;
val empty : ('a,'b)t -> unit;;
val map : ('a,'b) t -> 'a -> 'b;;
val dom : ('a,'b) t -> 'a list;;
val rng : ('a,'b) t -> 'b list;;
val in_dom : ('a,'b) t -> 'a -> bool;;
val inv : ('a,'b) t -> 'b -> 'a list;;
val add : ('a,'b) t -> 'a * 'b -> unit;;
val rmv : ('a,'b) t -> 'a -> unit;;
val remap : ('a,'b) t -> 'a -> 'b -> unit;;
val app : (('a * 'b) -> unit) -> ('a,'b) t -> unit;;
val toList : ('a,'b) t -> ('a * 'b) list;;

val freeze : ('a,'b) t -> ('a,'b) frozen_t;;
val unfreeze : ('a,'b) frozen_t -> ('a,'b) t -> unit;;

(* $Id: fmavm.mli,v 1.6 1999/06/29 07:47:16 loiseleu Exp $ *)
