(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 edit.mli                                 *)
(****************************************************************************)

(* The type of editors:
 *
 * An editor is a finite map, 'a -> 'b, which knows how to apply
 * modification functions to the value in the rane, and how to
 * focus on a member of the range.
 *
 * It also supports the notion of a limited-depth undo, and that certain
 * modification actions do not push onto the undo stack, since they are
 * reversible.
 *)

type ('a,'b,'c) t;;
val mt : unit -> ('a,'b,'c) t;;

(* sets the focus to the specified domain element, or if NONE,
 * unsets the focus *)
val focus : ('a,'b,'c) t -> 'a option -> unit;;

(* gives the last focused element or NONE if none *)
val last_focused : ('a,'b,'c) t -> 'a option;;

(* are we focused ? *)
val focusedp : ('a,'b,'c) t -> bool;;

(* If we are focused, then return the current domain,range pair. *)
val read : ('a,'b,'c) t -> ('a * 'b * 'c) option;;

(* mutates the currently-focused range element, pushing its
 * old value onto the undo stack
 *)
val mutate : ('a,'b,'c) t -> ('c -> 'b -> 'b) -> unit;;

(* mutates the currently-focused range element, in place. *)
val rev_mutate : ('a,'b,'c) t -> ('c -> 'b -> 'b) -> unit;;

(* Pops the specified number of elements off of the undo stack,
 * reinstating the last popped element
 *
 * the undo stack is independently managed for each range element.
 *)
val undo : ('a,'b,'c) t -> int -> unit;;

val create : ('a,'b,'c) t -> 'a * 'b * 'c * int option -> unit;;
val delete : ('a,'b,'c) t -> 'a -> unit;;

val dom : ('a,'b,'c) t -> 'a list;;

val empty : ('a,'b,'c) t -> unit;;

(* $Id: edit.mli,v 1.5 1999/06/29 07:47:15 loiseleu Exp $ *)
