(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                vernac.mli                                *)
(****************************************************************************)



(* Like Exc_located, but specifies the outermost file read, the input buffer
   associated to the location of the error, and the error itself. *)
exception Error_in_file of string * (string * CoqAst.loc) * exn

(* Read a vernac command on the specified input (parse only).
   Raises End_of_file if EOF (or Ctrl-D) is reached. *)
val parse_phrase : Pcoq.Gram.parsable * in_channel option -> CoqAst.t

(* Reads and executes vernac commands from a stream.
   The boolean just_parsing disables interpretation of commands. *)
exception DuringCommandInterp of CoqAst.loc * exn
exception End_of_input
val just_parsing : bool ref
val raw_do_vernac : Pcoq.Gram.parsable -> unit

(* Load a vernac file, verbosely or not. Errors are annotated with file
   and location *)
val load_vernac : bool -> string -> unit

(* $Id: vernac.mli,v 1.13 1999/06/29 07:47:07 loiseleu Exp $ *)
