(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               declare.mli                                *)
(****************************************************************************)

open Names
open Term
open Constrtypes

val is_global : identifier -> bool
val machine_variable :
  (context * context) ->
    (identifier * strength * bool * constr) -> unit

val machine_constant :
  (context * context) ->
    ((identifier * bool * strength) * constr) -> unit

val machine_constant_red :
  (context * context) ->
    ((identifier * bool * strength) * constr) -> Reduction.red_expr option 
      -> unit

val machine_constant_verbose :
  (context * context) ->
    ((identifier * bool * strength) * constr) -> unit

val machine_parameter :
  (context * context) -> (identifier * constr) -> unit

val machine_minductive :
  (context * context) -> int ->
    (identifier * name * type_judgement * constr * identifier array) array ->
      bool -> unit

val machine_syntax_constant :
  identifier -> (path_kind,constr) Listmap.t -> unit

val machine_abstraction : identifier -> int array -> constr -> unit

(* $Id: declare.mli,v 1.12 1999/08/06 20:49:08 herbelin Exp $ *)
