(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                               nametab.mli                                *)
(****************************************************************************)

open Names;;

val sp_of_id : path_kind -> identifier -> section_path;;
val fw_sp_of_id : identifier -> section_path;;

(* standard interface part for summaries *)
val push : identifier -> section_path -> unit;;
val init : unit -> unit;;
type frozen_t;;
val freeze : unit -> frozen_t;;
val unfreeze : frozen_t -> unit;;
val rollback : (unit -> unit) -> unit -> unit;;

(* $Id: nametab.mli,v 1.6 1999/06/29 07:46:59 loiseleu Exp $ *)
