(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                             constraintab.mli                             *)
(****************************************************************************)
open Pp
open Names
open Libobject
open Impuniv

val current_constraints : unit -> universes
val push : universes -> unit (* avec rollback *)

(* standard interface part for summaries *)
val init : unit -> unit
type frozen_t = universes
val freeze : unit -> frozen_t
val unfreeze : frozen_t -> unit
val rollback : (unit -> unit) -> unit -> unit

(* object functions *)
type universes_object = section_path * universes
val inUniverses : universes_object -> obj
val outUniverses : obj -> universes_object
val print_universes_object : universes_object -> std_ppcmds
val add_constraints_object : universes_object -> unit

(* $Id: constraintab.mli,v 1.10 1999/11/07 17:57:13 barras Exp $ *)
