/* (-*-c++-*-)
 * Authors:  Peter Holst Andersen (txix@diku.dk)
 *           Jens Peter Secher (jpsecher@diku.dk)
 * Content:  C-Mix system: "Switchboard" intermediate containers for C programs.
 *
 * Copyright  1998. The TOPPS group at DIKU, U of Copenhagen.
 * Redistribution and modification are allowed under certain
 * terms; see the file COPYING.cmix for details.
 */

#ifndef __SYNTAX__
#define __SYNTAX__

#include "Plist.h"
#include "cpgm.h"

// Switchboard for base type declarations.
typedef enum { P_Type_Unspecified, P_Int, P_Char, P_Float, P_Double,
               P_Void } Parse_BaseType;
typedef enum { P_Size_Unspecified, P_Short, P_Long } Parse_Size;
typedef enum { P_Sign_Unspecified, P_Signed, P_Unsigned } Parse_Sign;
typedef enum { P_NoStorageClass, P_Typedef, P_Extern, P_Static, P_Auto,
               P_Register } Parse_Storage;

class Parse_Type
{
  public:
    Parse_BaseType type;
    Parse_Size size;
    Parse_Sign sign;
    Parse_Storage storage;
    constvol qualifiers ;

    Parse_Type(void)
      : type(P_Type_Unspecified), size(P_Size_Unspecified),
        sign(P_Sign_Unspecified), storage(P_NoStorageClass) {}

    Parse_Type(Parse_BaseType t)
      : type(t), size(P_Size_Unspecified),
        sign(P_Sign_Unspecified), storage(P_NoStorageClass) {}

    Parse_Type(Parse_Size s)
      : type(P_Type_Unspecified), size(s),
        sign(P_Sign_Unspecified), storage(P_NoStorageClass) {}

    Parse_Type(Parse_Sign sgn)
      : type(P_Type_Unspecified), size(P_Size_Unspecified),
        sign(sgn), storage(P_NoStorageClass) {}

    Parse_Type(Parse_Storage s)
      : type(P_Type_Unspecified), size(P_Size_Unspecified),
        sign(P_Sign_Unspecified),  storage(s) {}

    Parse_Type* combine(const Parse_Type* const other);

    BaseTypeTag determine_type(void);

    char* show(void);
};

class Parse_UserType
{
  public:
    char const* id;
    UserTag type;
    Parse_Storage storage;
    constvol qualifiers ;

    Parse_UserType(char const* name, UserTag t)
      : id(name), type(t), storage(P_NoStorageClass) {}

    Parse_UserType* combine(const Parse_Type* const other);
    char* show(void);
};


class Parse_TypedefType
{
    Parse_TypedefType(VarDecl*,int,int=0) {}
public:
    VarDecl* type;
    constvol qualifiers ;
    Parse_Storage storage;
    Parse_TypedefType(VarDecl* t, constvol cv=constvol() )
        : type(t), qualifiers(cv), storage(P_NoStorageClass) {}
    Parse_TypedefType* combine(const Parse_Type* const other);
};

// Temporary container for postfixes (in declartors and casts)
// ie. char* const* (* a )() [];
//         ^^^^^^^^^^^   ^^^^^^

class Parse_Decl;
typedef enum { P_Pointer, P_Array, P_Function } Parse_PostfixTag;

class Parse_Postfix
{
    Parse_Postfix(int,int) {}
public:
    Parse_PostfixTag tag;
    bool varargs ;
    Expr* size;
    Plist<Type>* params;
    constvol qualifiers ;

    Parse_Postfix(constvol cv)
        : tag(P_Pointer), qualifiers(cv) {}

    Parse_Postfix(Parse_Type* t)
        : tag(P_Pointer), qualifiers(t->qualifiers) {}

    Parse_Postfix(Expr* s)
        : tag(P_Array), size(s) {}

    Parse_Postfix(Plist<Type>* p, bool v)
        : tag(P_Function), varargs(v), params(p) {}
};

// Used as Parse_Postfix, except that it also carries the name of the identifier
// being declared.
class Parse_IdPostfix
{
public:
    char* id;
    Position pos;
    Plist<Parse_Postfix>* postfix;
    Parse_IdPostfix(char* n, Position p, Plist<Parse_Postfix>* post)
        : id(n), pos(p), postfix(post) {}
    Parse_IdPostfix(char* n, Position p)
        : id(n), pos(p), postfix(new Plist<Parse_Postfix>()) {}
    Parse_IdPostfix* append_postfixes(Plist<Parse_Postfix>* pfs);
    Parse_IdPostfix* prepend_postfixes(Plist<Parse_Postfix>* pfs);
};


class Parse_MemberId
{
public:
    Parse_IdPostfix* p_id;
    Expr* bits;  
    Parse_MemberId(Parse_IdPostfix* pi, Expr* e)
        : p_id(pi), bits(e) {}
};

// Switch-board for declarations.
class Parse_Decl
{
  public:
    Type* type;
    Parse_Storage storage;
    char const* name;
    Position pos;
    Parse_Decl(Type* t, const Parse_Storage s = P_NoStorageClass) 
        : type(t), storage(s), name(NULL), pos() {}
    Parse_Decl(char* id, Position p) 
        : type(NULL), storage(P_NoStorageClass), name(id), pos(p) {}
    Parse_Decl(Type* t, char* id, Position p,
               const Parse_Storage s = P_NoStorageClass) 
        : type(t), storage(s), name(id), pos(p) {}
    Parse_Decl(const Parse_Decl* orig)
        : storage(orig->storage),  name(orig->name), pos(orig->pos) {
            type = orig->type->copy();
    }
    Parse_Decl* combine_with_postfix(Plist<Parse_Postfix>* list);
    Parse_Decl* combine_with_postfix(Parse_IdPostfix* d);
    
};

#endif
