/* (-*-c++-*-)
 * Time-stamp: <98/04/16 10:44:58 panic>
 * Authors:  The C-mix Team
 * Content:  C-Mix system: In-use constraints
 *
 * Copyright  1998. The TOPPS group at DIKU, U of Copenhagen.
 * Redistribution and modification are allowed under certain
 * terms; see the file COPYING.cmix for details.
 */

#ifndef __IUCONSTRAINT_C__
#define __IUCONSTRAINT_C__

#include "ALoc.h"
#include "map.h"
#include "Plist.h"
#include "fix.h"
#include "options.h"

#define iuadebug (debugstream_iua)

class InUseConstraint : public AbstractConstraint {
public:
  typedef map<ALocSet*, Plist<InUseConstraint>*, IDcompare >
          globalMapType;
private:
  ALocSet* superset;
  ALocSet* subset;
  ALocSet* diffset;
  globalMapType* subset2constraints;
  unsigned long ID;
  static unsigned long nextID;
public:
  InUseConstraint(globalMapType* gm, ALocSet* sup, ALocSet* sub) :
    superset(sup), subset(sub), diffset(NULL), subset2constraints(gm),
    ID(nextID++) { };
  InUseConstraint(globalMapType* gm,
	     ALocSet* sup, ALocSet* sub, ALocSet* diff) :
    superset(sup), subset(sub), diffset(diff), subset2constraints(gm),
    ID(nextID++) { };
  virtual bool update() {
    assert(subset != NULL);
    assert(superset != NULL);
    unsigned int presize = superset->size();
    if (iuadebug ^ 3) iuadebug << "updating " << *this << "\n";
    for (ALocSet::iterator i = subset->begin();
	 i != subset->end(); i++)
      if (diffset == NULL || diffset->find(*i) == diffset->end()) {
	superset->insert(*i);
      }
    return presize != superset->size();
  }
  Plist<InUseConstraint>* succs() {
    return (*(subset2constraints->find(superset))).second;
  }
  virtual void initSuccs() {
      Plist<InUseConstraint>* Succs = succs();
      FOREACH(i,Succs,InUseConstraint)
          one_successor(*i);
  }
  virtual void show(ostream& s);
};

unsigned long InUseConstraint::nextID = 0;

void InUseConstraint::show(ostream& s) {
  s << "[" << ID << ":" << *superset << ">=" << *subset << "\\";
  if (diffset == NULL) s << "<null>"; else s << *diffset;
  s << ":";
  Plist<InUseConstraint>* cs = succs();
  Plist<InUseConstraint>::iterator i = cs->begin();
  if (i != cs->end()) { s << (*i)->ID; i++; }
  for (; i != cs->end(); i++) {
    s << "," << (*i)->ID;
  }
  s << "]";
}

#endif
