#ifndef _TURNG_H
#define _TURNG_H

typedef int InstructionTag;
#define Left     0 /* Left        */
#define Right    1 /* Right       */
#define Write    2 /* Write a     */
#define Goto     3 /* Goto  i     */
#define IfGoto   4 /* If a Goto i */
#define Stop     5 /* Stop        */
#define ReadGoto 6 /* ReadGoto    */

typedef struct Instruction {
  InstructionTag tag; 
  char a;
  int i;
} Instruction;

#define MAXINSTRS 31

extern int instrs;

extern Instruction instruction[MAXINSTRS];

void readTuringProgram(char* filename);
void printstatus(char*, int);
#pragma cmix pure: readTuringProgram() printstatus()

#endif
