########################################################################
proc blanks {num} {
  return [string range {                                         }\
	      1 $num]
}
########################################################################
##
## generate count description for usage-function, i.e. s.th. like
##      3...6 integer values
## or
##      1 or more string values
##
proc usageCount {opt} {
  global D

  append usage $D($opt,cmin)
  if { [Infty $D($opt,cmax)] } {
    append usage " or more"
  } elseif { $D($opt,cmax)>$D($opt,cmin) } {
    append usage "...$D($opt,cmax)"
  }
  if { $D($opt,cmax)==1 && $D($opt,cmin)==1} {
    append usage " $D($opt,typename) value"
  } else {
    append usage " $D($opt,typename) values"
  }	
}
########################################################################
proc genUsage {} {
  global D L usageString versionString

  #####
  ##### generate usage line 1
  #####
  set usage {}
  foreach opt $L {
    set optional [expr ![info exist D($opt,mandatory)]]
    set parOptional [expr {$D($opt,type)!="flag" && 0==$D($opt,cmin)}]

    if $optional { 
      append usage " \[$opt" 
    } else {
       append usage " $opt" 
    }

    if { $D($opt,type)!="flag" } {
      if $parOptional { 
	append usage " \[$D($opt,name)\]" 
      } else { 
	append usage " $D($opt,name)" 
      }
    }

    if $optional { append usage "\]" }
  }

  if { [info exist D(...,name)] } {
    append usage " "
    if { $D(...,cmin)==0 } {append usage "\["}
    append usage "$D(...,name)"
    if { [Infty $D(...,cmax)] || $D(...,cmax)>1 }  {append usage " ..."}
    if { $D(...,cmin)==0 } {append usage "\]"}
  }
  regsub -all "\n" $usageString "\\n\\\n    " usageString
  append usage "\\n\\\n"
  append usage "    $usageString\\n\\\n"

  #####
  ##### find maximum length of options
  #####
  if { [info exist D(...,name)] } {
    set max [string length $D(...,name)]
  } else {
    set max 0
  }
  foreach opt $L {
    set l [string length $opt]
    if { $l>$max } {set max $l}
  }
  incr max 2

  #####
  ##### description of every option
  #####
  foreach opt $L {
    set l [string length $opt]
    append usage [blanks [expr $max-$l]]
    set tab [blanks [expr $max+2]]
    regsub -all "\n" $D($opt,usage) "\\n\\\n$tab" s
    append usage "$opt: $s\\n\\\n"

    if { $D($opt,type)!="flag" } {
      ##### count
      append usage [blanks [expr $max+2]] [usageCount $opt]

      ##### range
      if { [info exist D($opt,min)] && 
	   (![negInfty $D($opt,min)] || ![Infty $D($opt,max)]) } {
	append usage " between $D($opt,min) and $D($opt,max)"
      }
      ##### default:
      if { [info exist D($opt,default)] } {
	append usage "\\n\\\n[blanks $max]  default:"
	foreach x $D($opt,default) {
	  append usage " `$x'"
	}
      }
      append usage "\\n\\\n"
    }
  }
  #####
  ##### description of non-option arguments
  #####
  if { [info exist D(...,name)] } {
    set l [string length $D(...,name)]
    append usage [blanks [expr $max-$l]]
    set tab [blanks [expr $max+2]]
    regsub -all "\n" $D(...,usage) "\\n\\\n$tab" s

    append usage "$D(...,name): $s\\n\\\n"
    append usage [blanks [expr $max+2]] [usageCount ...] "\\n\\\n"
  }

  #####
  ##### version string
  #####
  if { [info exist versionString] } {
    append usage "version: $versionString\\n\\\n"
  }

  set res    "void\n"
  append res "usage(void)\n"
  append res "{\n"
  append res "  fprintf(stderr, \"usage: %s%s\", Program, \"\\\n"
  append res "$usage\");\n"
  append res "  exit(EXIT_FAILURE);\n"
  append res "}\n"
  append res "/***********************************"
  append res "***********************************/"
  return $res

}
########################################################################
