
## generate the structure to hold command line parameters
## The following variables are generated for an option with name bla:
##   char blaP : will be set to true, if the option shows up.
## Except for type Flag, also the following vars are generated
##   int bla : the option value if cmax==1
## or
##   int *bla : the values, if cmax>1
##   int blaC : number of values, if cmin<cmax
##
## The generated C-code is returned as the function result.
##
proc genStruct {} {
  global D L

  set res "typedef struct s_Cmdline \{\n"
  
  foreach opt $L {
    append res \
	"  /***** $opt: $D($opt,usage) */\n"\
	"  char $D($opt,name)P;\n"
    
    if { $D($opt,type)=="flag" } continue

    if { $D($opt,cmax) == 1 } {
      append res "  $D($opt,type) $D($opt,name);\n"
    } else {
      append res "  $D($opt,type) *$D($opt,name);\n"
    }

    append res "  int $D($opt,name)C;\n"

  }
  append res \
      "  /***** uninterpreted command line parameters */\n"\
      "  int argc;\n"\
      "  /*@null*/char **argv;\n"

  ## Do we generate a copy of the command line as one string?
  global argvString
  if [info exist argvString] {
    append res \
	"  /***** the whole command line concatenated */\n"\
	"  char *$argvString;\n"
  }
  append res \
      "\} Cmdline;\n"

  return $res
}


