------------------------------------------------------------------------------
--                                                                          --
--                 ASIS-for-GNAT IMPLEMENTATION COMPONENTS                  --
--                                                                          --
--                         A 4 G . S _ U _ I N F O                          --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1995-1999, Free Software Foundation, Inc.       --
--                                                                          --
-- ASIS-for-GNAT is free software; you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIS-for-GNAT is distributed  in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License  distributed with ASIS-for-GNAT; see file     --
-- COPYING. If not, write to the Free Software Foundation,  59 Temple Place --
-- - Suite 330,  Boston, MA 02111-1307, USA.                                --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- ASIS-for-GNAT was originally developed  by the ASIS-for-GNAT team at the --
-- Software  Engineering  Laboratory  of  the Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne,  Switzerland, in cooperation with the --
-- Scientific  Research  Computer  Center of  Moscow State University (SRCC --
-- MSU), Russia,  with funding partially provided  by grants from the Swiss --
-- National  Science  Foundation  and  the  Swiss  Academy  of  Engineering --
-- Sciences.  ASIS-for-GNAT is now maintained by  Ada Core Technologies Inc --
-- (http://www.gnat.com).                                                   --
--                                                                          --
------------------------------------------------------------------------------

with Asis;            use Asis;
with Asis.Extensions; use Asis.Extensions;

with A4G.A_Types;     use A4G.A_Types;
with A4G.Contt;       use A4G.Contt;
with A4G.Contt.UT;    use A4G.Contt.UT;

with Types;           use Types;

package body A4G.S_U_Info is

   --------------------------
   -- Set_Predefined_Units --
   --------------------------

   procedure Set_Predefined_Units is
      Cont : Context_Id := Get_Current_Cont;
      C_U  : Unit_Id;
   begin

      --  set the entry for the package Standard:

      Set_Name_String ("standard%s");
      C_U := Allocate_Unit_Entry (Cont);
      --  C_U should be equial to Standard_Id. Should we check this here?

      Set_Name_String ("Standard");
      Set_Ada_Name (Cont, C_U);
      Set_Kind     (Cont, C_U, A_Package);
      Set_Class    (Cont, C_U, A_Public_Declaration);
      Set_Top      (Cont, C_U, Empty);
      --  What is the best solution for computing the top node of the
      --  subtree for the package Standard? Now we compute it in
      --  Asis.Set_Get.Top...


      Set_Time_Stamp  (Cont, C_U, Empty_Time_Stamp);
      Set_Origin      (Cont, C_U, A_Predefined_Unit);

      Set_Is_Main_Unit (Cont, C_U, False);
      Set_Is_Body_Required (Cont, C_U, False);

      Set_Source_Status    (Cont, C_U, Absent);

      --  as for the source file, it was set to Nil when allocating the
      --  unit entry

   end Set_Predefined_Units;

end A4G.S_U_Info;