------------------------------------------------------------------------------
--                                                                          --
--                 ASIS-for-GNAT IMPLEMENTATION COMPONENTS                  --
--                                                                          --
--                         A 4 G . G N A T _ I N T                          --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1995-1999, Free Software Foundation, Inc.       --
--                                                                          --
-- ASIS-for-GNAT is free software; you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIS-for-GNAT is distributed  in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License  distributed with ASIS-for-GNAT; see file     --
-- COPYING. If not, write to the Free Software Foundation,  59 Temple Place --
-- - Suite 330,  Boston, MA 02111-1307, USA.                                --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- ASIS-for-GNAT was originally developed  by the ASIS-for-GNAT team at the --
-- Software  Engineering  Laboratory  of  the Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne,  Switzerland, in cooperation with the --
-- Scientific  Research  Computer  Center of  Moscow State University (SRCC --
-- MSU), Russia,  with funding partially provided  by grants from the Swiss --
-- National  Science  Foundation  and  the  Swiss  Academy  of  Engineering --
-- Sciences.  ASIS-for-GNAT is now maintained by  Ada Core Technologies Inc --
-- (http://www.gnat.com).                                                   --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains the utility routines used for calling the GNAT
--  compiler from inside the ASIS implementation routines. The idea is to
--  call GNAT in a black-box manner. The current version of this package
--  borrows most of the ideas and the code patterns from the body of the
--  GNAT Make package (which defines the gnatmake-related routines).
--  Unfortunately, GNAT do not provide the public interface to these
--  routines, so we simply have copied the code from make.adb with some
--  modifications.
--
--  THIS PACKAGE MAY REQUIRE REVISION IF SOME MORE STUFF FROM THE GNAT
--  PACKAGES MAKE AND OSINT ARE MOVED TO THEIR INTERFACES.

--  This package also contains some routines providing the interface
--  between GNAT and ASIS notions


with Ada.Calendar; use Ada.Calendar;

with A4G.A_Types;  use A4G.A_Types;
with A4G.A_Debug;

with GNAT.OS_Lib;  use GNAT.OS_Lib;
with Types;        use Types;

package A4G.GNAT_Int is

   -----------------------------------
   -- Compiler Variables & Routines --
   -----------------------------------

   Gcc      : constant String := "gcc";

   Nul_Argument_List : constant Argument_List (1 .. 0) := (others => null);

   Path         : constant String_Access := Getenv ("PATH");

   Comp_Flag    : constant String_Access := new String'("-c");

   GNAT_Flag    : constant String_Access := new String'("-gnatg");
   GNAT_Flag_c  : constant String_Access := new String'("-gnatc");
   GNAT_Flag_t  : constant String_Access := new String'("-gnatt");
   GNAT_Flag_ws : constant String_Access := new String'("-gnatws");

--  The GNAT flags are set now in a way which allows to get the tree file
--  for an AST corresponding to the "compile-only" (-gnatc) GNAT mode.
--  This tree does not contain the results of the expansions.

--  GNAT_Flags are intendedto be used when the "standard" installation of
--  the GNAT compiler is called from inside ASIS.

   Display_Executed_Programs : Boolean renames A4G.A_Debug.Debug_Mode;
   --  Set to True if name of commands should be output on stderr.
   --  Now this flag is toughtly binded with the flag setting the
   --  ASIS Debug Mode. Is it a good decision?

   function Execute (Program : String; Args : Argument_List) return Boolean;
   --  Executes Program.  Args contains the arguments to be passed to
   --  Program.  If the program is executed successfully True is returned.

   procedure Compile (Source_File : in  String_Access;
                      Args        : in  Argument_List;
                      Success     : out Boolean);
   --  Invokes GNAT by calling to gcc.
   --
   --  This is the modified version of the GNAT Compile procedure from
   --  make.adb. Three modifications have been made:
   --
   --  1. It does not raise an exception if the compilation failed,
   --     instead it sets the Success flag OFF (if the compilation was
   --     susseccful, the flag is set ON)
   --
   --  2. It gets the name of the source file being compiled as the
   --     reference to a NUL-terminated string, but not as the reference
   --     in the GNAT Name Table. A caller is responcible for the fact
   --     that this string value has already been NUL-terminated.
   --
   --  3. It always sets the "-gnatc" (copile-only) and "-gnatt" (generate
   --     tree output file) GNAT flags
   --
   --  It is supposed that Adrs parameter is the list of "-I" GNAT options
   --  obtained from corresponding ASIS Context.

   procedure Create_Tree (Source_File   : in  String_Access;
                          Context       : in  Context_Id;
                          Is_Predefined : in  Boolean;
                          Success       : out Boolean);
   --  Tries to create the tree output file for the given source file
   --  in the context of a given Context. Uses the "standard" GNAT
   --  installation to do this

   ----------------------------------------------
   -- General Interfaces between GNAT and ASIS --
   ----------------------------------------------

   function A_Time (T : Time_Stamp_Type)
      return Time;
   --  Converts GNAT file time stamp into the corresponding value
   --  of Asis_Time.

end A4G.GNAT_Int;