/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>

#include "common/common.h"
#include "logfile/logfile.h"

#include "gs_token.h"
#include "gs_list.h"
#include "gs_translate.h"
#include "gs_parser.h"

#include "gs_create.h"
#include "gs_getdict.h"

/* -------------------------------------------------------------------- */

#define DICT_LOAD "myfile.load"
#define DICT_SAVE "myfile.save"

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
int main(int argc, char **argv)
{

	TOKEN_LIST
		*eptr;

	TOKEN 	
		*item,
		*dict;

	TOKEN	*token;


	set_logfile(LOGFILE);
	set_loglevel(LOGLEVEL);
	set_consolelog(TRUE);


	/* ---------------------------------------- */

	item = create_dictionary("dictionary");

	if (gs_isdictionary(item))
	{	lprintf(LOG_STANDARD, "Item is Dictionary\n");
	}
	else
	{	lprintf(LOG_STANDARD, "Item is NOT Dictionary\n");
		exit(1);
	}


	/* ---------------------------------------- */

	if (gs_loaddictionaryfromfile(DICT_LOAD, item) == -1)
	{	lprintf(LOG_ERROR, "Failed to load Dictionary '%s'\n", DICT_LOAD);
		exit(1);
	}
	else
	{	lprintf(LOG_STANDARD, "Loaded Dictionary '%s'\n", DICT_LOAD);
	}


	/* ---------------------------------------- */


	eptr = NULL;
	while ((token = gs_get_dictionary_next(item, &eptr)) != NULL) 
	{
		if (gs_isidentifier(token))
		{
			lprintf(LOG_STANDARD, "Identifier '%s'\n", gs_get_labelvalue(token));
		}
		else
		if (gs_isdictionary(token))
		{
			lprintf(LOG_STANDARD, "Dictionary '%s'\n", gs_get_labelvalue(token));
		}
		else
		if (gs_islist(token))
		{
			lprintf(LOG_STANDARD, "List '%s' len '%d'\n", gs_get_labelvalue(token), gs_get_list_length(token));

		}
		else
		{
			lprintf(LOG_STANDARD, "Unknown\n");
		}

		if (eptr == NULL)
		{	break;
		}
	}

	if (eptr != NULL)
	{
		lprintf(LOG_ERROR, "Something went wrong!\n");
	}


	/* ---------------------------------------- */


	if (gs_savedictionarytofile(DICT_SAVE, item) == -1)
	{	lprintf(LOG_ERROR, "Failed to Save Dictionary '%s'\n", DICT_SAVE);
		exit(1);
	}
	else
	{	lprintf(LOG_STANDARD, "Saved Dictionary '%s'\n", DICT_SAVE);
	}

	return 0;
}

