/* -------------------------------------------------------------------- */
/* SMS Client, send messages to mobile phones and pagers		*/
/*									*/
/* common.c								*/
/*									*/
/*  Copyright (C) 1997,1998,1999 Angelo Masci				*/
/*									*/
/*  This library is free software; you can redistribute it and/or	*/
/*  modify it under the terms of the GNU Library General Public		*/
/*  License as published by the Free Software Foundation; either	*/
/*  version 2 of the License, or (at your option) any later version.	*/
/*									*/
/*  This library is distributed in the hope that it will be useful,	*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of	*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU	*/
/*  Library General Public License for more details.			*/
/*									*/
/*  You should have received a copy of the GNU Library General Public	*/
/*  License along with this library; if not, write to the Free		*/
/*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	*/
/*									*/
/*  You can contact the author at this e-mail address:			*/
/*									*/
/*  angelo@styx.demon.co.uk						*/
/*									*/
/* -------------------------------------------------------------------- */
/* $Id$
   -------------------------------------------------------------------- */

#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdarg.h>

#include "common/common.h"

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
size_t sms_strlen(const char *s)
{
	if (s == NULL)
	{	fprintf(stderr, "WARNING: SMS Client tried to calculate the length of a NULL string\n");
		return 0;
	}

	return strlen(s);
}

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
char *sms_strcpy(char *dest, const char *src)
{
	if (dest == NULL)
	{	fprintf(stderr, "WARNING: SMS Client tried to copy a string to an address set to NULL\n");
		return NULL;
	}
 
	if (src == NULL)
	{	fprintf(stderr, "WARNING: SMS Client tried to copy a NULL string\n");

		dest[0] = '\0';
		return dest;
	}

	return strcpy(dest, src);
}

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
char *sms_strcat(char *dest, const char *src)
{
	if (dest == NULL)
	{	fprintf(stderr, "WARNING: SMS Client tried to append a string to an address set to NULL\n");
		return NULL;
	}

	if (src == NULL)
	{	fprintf(stderr, "WARNING: SMS Client tried to append a NULL string\n");
		return dest;
	}

	return strcat(dest, src);
}

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
void sms_usleep(long microseconds)
{
#if defined(LINUX)
	usleep(microseconds);
#else
        struct  timeval 
                timeout;
        
        timeout.tv_usec = microseconds % 1000000;
        timeout.tv_sec  = microseconds / 1000000;
        
        select(0, NULL, NULL, NULL, &timeout);
#endif
}

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
void sms_bzero(void *destination, size_t length)
{
#if defined(LINUX)
	bzero(destination, length);
#else
	memset(destination, '\0', length);
#endif
}

/* -------------------------------------------------------------------- */
/* Add a file/directory name to a pathname. If the path			*/
/* does not end with '/' append one before adding the other		*/
/* file/dir.								*/
/* -------------------------------------------------------------------- */
char *sms_filecat(char *path, char *element)
{
	if (path[sms_strlen(path)] != '/')
	{	sms_strcat(path, "/");
	}

	return sms_strcat(path, element);
}

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
int sms_snprintf(char *dst, int len, const char *fmt, ...)
{
	va_list args;
	int 	res;


	va_start(args, fmt);
#if !defined(LINUX)
	res = vsprintf(dst, fmt, args);
#else
	res = vsnprintf(dst, len, fmt, args);
#endif
	va_end(args);

	return res;
}

