/*
   flashwrite.c: programming the flash memory on a NetWinder
   Copyright 1998  woody@corelcomputer.com

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>

#include "flash.h"

int main (int argc, char **argv)
{
   int	fd = 0;
   int	uTemp = 0;
   int	uTemp1 = 0;
   int	uOffset = 0;
   int	base64 = 0;
   char*	filebuf;
   char*	basename;
   char* 	p;
   char	buff[64];

   //	printf("\nargc=%d, argv:[0]=%s, [1]=%s, [2]=%s, [3]=%s.\n\n",
   //	    argc,argv[0],argv[1],argv[2],argv[3]);

   basename = (p = strrchr(argv[0], '/')) ? p+1 : argv[0];

   if(argc != 3 && (argc != 4 || strcmp(*(++argv),"-base64")) )
   {
      fprintf(stderr,"\nNetwinder Flash Memory update program, Corel Computer 1998.\nUsage: %s [-base64] filename	 offset(hex).\n\n",
	 basename);
      return EXIT_FAILURE;
   }

   if (!strcmp(argv[0],"-base64"))
      base64++;

   fd = open(argv[1], O_RDONLY);

   if (fd <= 0)
   {
      fprintf(stderr,"%s: unable to open file \"%s\", error 0x%X.\n",
	 basename, argv[1], errno);
      return EXIT_FAILURE;
   }

   //else open OK, load the file into memory
   uTemp = lseek(fd, 0 , 2);	//seek to end

   filebuf = (char *)malloc (uTemp);
   uTemp1 = lseek(fd, 0, 0);
   uTemp1 = read(fd,filebuf,uTemp);
   close(fd);

   if ((uTemp = sscanf(argv[2], "%x", &uOffset)) <= 0)
   {
      fprintf(stderr,"%s: unable to read hex offset in the flash (\"%s\")???.\n",
	 basename, argv[2]);
      free(filebuf);
      return EXIT_FAILURE;
   }

   fflush(stdin);
   fprintf(stderr,"\n%s: ready to write into flash memory\n  file   : \"%s\"\n  size   : %d bytes\n  offset : 0x%X\n\n",
      	    basename, argv[1], uTemp1, uOffset);

   if (base64)
      fprintf(stderr,"\nWarning: write to base 64k of flash enabled!\n\n");

   fprintf(stderr,"Press Y to continue, or anything else to abort ...\n\n");

   fgets(buff,3,stdin);
   if (tolower(buff[0]) != 'y')
   {
      printf("\nNot this time... Abort.\n\n");
      return EXIT_FAILURE;
   }

   printf("\nPlease wait. Yellow LED - erasing, Red LED - writing, Green LED - verifying...\n");


   fd = open("/dev/nwflash", O_RDWR);
   if (fd <0)
   {
      printf("Error %d opening /dev/nwflash\n",fd);
      free(filebuf);
      return EXIT_FAILURE;
   }

   uTemp = lseek(fd, uOffset, 0);
   //	printf("Seek rc = 0x%X.\n",uTemp);

   ioctl(fd, CMD_WRITE_ENABLE);
   if (base64)
      ioctl(fd, CMD_WRITE_BASE64K_ENABLE);


   uTemp = write(fd,filebuf,uTemp1);
   if (uTemp == uTemp1)
      printf("Flash write: written %d bytes OK.\n", uTemp);
   else
   {
      if (uTemp < 0)
      {
	 printf("ERROR: flash write returned error %d!\n",
	    uTemp);
      }
      else
      {
	 printf("ERROR: flash write : written %d out of %d bytes!\n",
	    uTemp, uTemp1);
      }
   }

   ioctl(fd, CMD_WRITE_DISABLE);
   free(filebuf);

   if (close(fd) != 0)
      printf("Error closing /dev/nwflash\n");

   if (uTemp == uTemp1)
      return EXIT_SUCCESS;
   else
      return EXIT_FAILURE;

}
