/* Copyright:  GPL */
/*
  Witten by joost witteveen;  
  read_pkginfo function by Tom Lees, run_menumethods by both.
  
  */

#include "update-menus.h"
#include <fstream.h>
#include <set>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <ctype.h>
#include <dirent.h>
#include <signal.h>
#include <syslog.h>
#include <errno.h>
#include <procbuf.h>

int debug=0, verbose=0;
set <String, less<String> > installed_packages;
set <String, less<String> > menufiles_processed;
translateinfo *transinfo;
configinfo     config;

DIR *open_dir_check(String dirname){
  struct stat st;
  int r;

  r=stat (dirname.c_str(), &st);
  if (r || (!S_ISDIR (st.st_mode)))
    throw dir_error_read(dirname);

  return opendir (dirname.c_str());
}

bool executable(const String &s){
  struct stat st;
  int r;
  r=stat (s.c_str(), &st);
  if(r!=0)
    return false;
  else
    return (((st.st_mode & S_IXOTH) || 
	     ((st.st_mode & S_IXGRP) && st.st_gid == getegid ()) || 
	     ((st.st_mode & S_IXUSR) && st.st_uid == geteuid ())) && 
	    (S_ISREG(st.st_mode) || S_ISLNK(st.st_mode)));
}

/////////////////////////////////////////////////////
//  menuentry:
//

/*void gettext_translate(menuentry &m){
  StrVec v;
  StrVec::iterator i;
  String t;

  
  t=String(dgettext(GETTEXTDOMAIN,m.data[TITLE_VAR].c_str()));
  m.data[TITLE_VAR]=t;

  t=m.data[SECTION_VAR];
  break_slashes(t,v);
  t=String("");
  for(i=v.begin(); i!=v.end(); i++){
    if(i!=v.begin())
      t=t+String("/");
    t=t+String(dgettext(GETTEXTDOMAIN,(*i).c_str()));
  }
  m.data[SECTION_VAR]=t;
}
*/
bool menuentry::test_installed(String filename){
  
  if(filename.contains("local.",0))
    return true;
  else
    return installed_packages.find(filename)!=installed_packages.end();
}

bool menuentry::check_install(parsestream &i, String &name){
  String function;

  function=i.get_name();
  if(function!=String(COND_PACKAGE))
    throw unknown_cond_package(&i, function);
  i.skip_char('(');
  name=i.get_name();
  if(!test_installed(name)){
    i.skip_line();
    throw cond_inst_false();
  }
  i.skip_char(')');
  return true;
}

void menuentry::menuentry_constr_gccbug(parsestream &i)
{ 
  char c;
  String name, val;
  //new format menuentry
  
  //read available info
  check_install(i, name);
  data[PACKAGE_VAR]=name;
  i.skip_space();
  i.skip_char(':');
  //read menuentry:
  try{
    do{
      name=i.get_name();
      val=i.get_eq_Stringconst();
      data[name]=val;
      c=i.get_char();
      i.put_back(c);
    }while(c);
  }
  catch(endofline){};
  i.skip_line();
}

menuentry::menuentry(parsestream &i, const String &filename){
  char c;

  c=i.get_char();
  if(c=='?'){
    menuentry_constr_gccbug(i);
  }else{
    //old format menuentry
    if(!test_installed(filename)){
      i.skip_line();
      throw cond_inst_false();
    }
    data[PACKAGE_VAR]=filename;
    i.put_back(c);
    data[NEEDS_VAR]  =i.get_Stringconst();
    data[SECTION_VAR]=i.get_Stringconst();
    i.get_Stringconst(); //id is unused
    data[ICON_VAR]   =i.get_Stringconst();
    data[TITLE_VAR]  =i.get_Stringconst();
    i.skip_space();
    data[COMMAND_VAR]=i.get_line();
  }
}

void menuentry::output(vector<String> &s){
  String t;
  map<String, String, less<String> >::iterator i;
  if((i=data.begin())!=data.end())
    while (true){
      t+=String((*i).first) + "=\"" + 
	 escape_String((*i).second,"\"\n") + "\"";
      i++;
      if(i==data.end()){
	break;
      } else
	t+=" ";
    }
  t+="\n";
  config.report(String("ADDING: ")+t,configinfo::report_debug);
  s.push_back(t);
}

ostream &menuentry::debugoutput(ostream &o){
  map<String, String, less<String> >::iterator i;

  o<<"MENUENTRY:"<<endl;
  for(i=data.begin(); i!=data.end(); i++)
    o<<"  data["<<(*i).first<<"]="<<(*i).second<<endl;
  return o;
}

/////////////////////////////////////////////////////
//  configinfo
//
configinfo::configinfo(){
  verbosity=report_quiet;
  method=method_stderr;
  compat=parsestream::eol_newline;
  usedefaultmenufilesdirs=true;
}

void configinfo::parse_def(const String &var, parsestream &p){
  String s;
  s=p.get_Stringconst();
  if(var==String("compat")){
    if(s==String("menu-1")) compat=parsestream::eol_newline;
    else if(s==String("menu-2")) compat=parsestream::eol_semicolon;
    else throw def_error(&p, s);
  } else if(var==String("verbosity")){
    if     (s==String("quiet"))   verbosity=report_quiet;
    else if(s==String("normal"))  verbosity=report_normal;
    else if(s==String("verbose")) verbosity=report_verbose;
    else if(s==String("debug"))   verbosity=report_debug;
    else throw def_error(&p, s);
  } else if(var==String("method")){
    if     (s==String("stdout"))  method=method_stdout;
    else if(s==String("stderr"))  method=method_stderr;
    else if(s==String("syslog")) { 
      method=method_syslog;
      String facility;
      String priority;
      facility=p.get_Stringconst();
      cerr<<"FACILITY="<<facility<<endl;

      priority=p.get_Stringconst();
      cerr<<"priority="<<priority<<endl;
           if(facility==String("auth"))       syslog_facility=LOG_AUTH;
      else if(facility==String("authpriv"))   syslog_facility=LOG_AUTHPRIV;
      else if(facility==String("authcron"))   syslog_facility=LOG_CRON;
      else if(facility==String("authdaemon")) syslog_facility=LOG_AUTHPRIV;
      else if(facility==String("authkern"))   syslog_facility=LOG_KERN;
      else if(facility==String("authlocal0")) syslog_facility=LOG_LOCAL0;
      else if(facility==String("authlocal1")) syslog_facility=LOG_LOCAL1;
      else if(facility==String("authlocal2")) syslog_facility=LOG_LOCAL2;
      else if(facility==String("authlocal3")) syslog_facility=LOG_LOCAL3;
      else if(facility==String("authlocal4")) syslog_facility=LOG_LOCAL4;
      else if(facility==String("authlocal5")) syslog_facility=LOG_LOCAL5;
      else if(facility==String("authlocal6")) syslog_facility=LOG_LOCAL6;
      else if(facility==String("authlocal7")) syslog_facility=LOG_LOCAL7;
      else if(facility==String("authlpr"))    syslog_facility=LOG_LPR;
      else if(facility==String("authmail"))   syslog_facility=LOG_MAIL;
      else if(facility==String("authnews"))   syslog_facility=LOG_NEWS;
      else if(facility==String("authsyslog")) syslog_facility=LOG_SYSLOG;
      else if(facility==String("authuser"))   syslog_facility=LOG_USER;
      else if(facility==String("authuucp"))   syslog_facility=LOG_UUCP;
      else throw def_error(&p, facility);

	   if(priority==String("emerg"))      syslog_priority=LOG_EMERG;
      else if(priority==String("alert"))      syslog_priority=LOG_ALERT;
      else if(priority==String("crit"))       syslog_priority=LOG_CRIT;
      else if(priority==String("err"))        syslog_priority=LOG_ERR;
      else if(priority==String("warning"))    syslog_priority=LOG_WARNING;
      else if(priority==String("notice"))     syslog_priority=LOG_NOTICE;
      else if(priority==String("info"))       syslog_priority=LOG_INFO;
      else if(priority==String("debug"))      syslog_priority=LOG_DEBUG;
      else throw def_error(&p, priority);
    }
    else throw def_error(&p,s);
  }
  else throw def_error(&p, var);
}

void configinfo::update(String filename){
  try{
    parsestream p(filename);
    while(true){
      String var;
      var=p.get_name();
      p.skip_char('=');
      parse_def(var,p);
      p.skip_line();
    }
  } 
  catch (endoffile){};
}

void configinfo::report(const String &message,
			verbosity_type v){
  if(v<=verbosity){
    switch(method){
    case method_stdout:
      cout<<"Update-menus["<<getpid()<<"]: "<<message<<endl;
      break;
    case method_stderr:
      cerr<<"Update-menus["<<getpid()<<"]: "<<message<<endl;
      break;
    case method_syslog:
      openlog("update-menus",LOG_PID,syslog_facility);
      syslog(syslog_priority,message.c_str());
      closelog();
    }
  }
}
/////////////////////////////////////////////////////
//  translate stuff
//

trans_class::trans_class(const String &m,
			 const String &r,
			 const String &rv){
  match=m;
  replace=r;
  replace_var=rv;
}

trans_class::~trans_class(){
  
}

bool  trans_class::check(String &s){
  config.report(String("checking ")+match+" < "+s,configinfo::report_debug);
  return match.contains(s,0);
}

String trans_class::debuginfo(){
  return String(" match=")+match+", replace="+replace+", replace_var="+replace_var;
}

void translate::process( menuentry &m,
			const String &v){
  if(v==match)
    m.data[replace_var]=replace;
}
void subtranslate::process( menuentry &m,
			 const String &v){
  if(v.contains(match,0)){
    m.data[replace_var]=replace;
  }
}

void substitute::process( menuentry &m,
		   const String &v){
  String s,*t;
  if(v.contains(match,0)){
    t=&(m.data[replace_var]);
    if(t->length()>=replace.length())
      *t=replace+t->after(match.length());
  }
}

void translateinfo::init(parsestream &i){
  String name, match, replace, match_var, replace_var;
  Regex ident("[a-zA-Z_][a-zA-Z0-9_]*");

  config.report(String("Reading translate info in ")+i.filename(),
		configinfo::report_verbose);
  while(true){
    name=i.get_name(ident);
    config.report(String("name=")+name,
		  configinfo::report_debug);
    i.skip_space();
    match_var=i.get_name(ident);
    config.report(String("match_var=")+match_var,
		  configinfo::report_debug);
    i.skip_space();
    i.skip_char('-');
    i.skip_char('>');
    i.skip_space();
    replace_var=i.get_name(ident);
    config.report(String("replace_var=")+replace_var,
		  configinfo::report_debug);
    
    i.skip_line();
    while(true){
      trans_class *trcl;
      
      i.skip_space();
      match=i.get_Stringconst();
      if(match==String(ENDTRANSLATE_TRANS)){
	i.skip_line();
	break;
      }
      if(match[0]=='#'){
	i.skip_line();
	continue;
      }
      i.skip_space();
      replace=i.get_Stringconst();
      if(name==TRANSLATE_TRANS)
	trcl=new translate(match,replace,replace_var);
      if(name==SUBTRANSLATE_TRANS)
	trcl=new subtranslate(match,replace,replace_var);
      if(name==SUBSTITUTE_TRANS)
	trcl=new substitute(match,replace,replace_var);
      
      pair<const String, trans_class *> p(match,trcl);
      
      config.report(String("adding translate rule: [")+p.first+
		    "]"+ trcl->debuginfo(),
		    configinfo::report_debug);
      trans[match_var].insert(p);
      i.skip_line();
    }
  }
}

translateinfo::translateinfo(parsestream &i){
  init(i);
}

translateinfo::translateinfo(const String &filename){
  try{
    config.report(String("attempting to open ")+filename+".. ",
		  configinfo::report_debug);
    parsestream ps(filename);
    
    init(ps);
  }
  catch(endoffile p)
    {config.report(String("End reading translate info"),
		   configinfo::report_debug);}
  
}

void translateinfo::process(menuentry &m){
  map<String, trans_map, less<String> >::iterator i;
  trans_map::iterator j;
  String *match;
  for(i=trans.begin(); i!=trans.end(); i++){
    match=&m.data[(*i).first];
    j=(*i).second.lower_bound(*match);
    if((j==(*i).second.end()) ||
       ((j!=(*i).second.begin()) && ((*j).first != *match)))
      j--;
    do{
      config.report(String("translate: var[")+*match+"]"+
		    " testing trans rule match for:"+
		    (*j).first,
		    configinfo::report_debug);
      (*j).second->process(m,*match);
      j++;
    } while((j!=(*i).second.end())&&
	    (*j).second->check(*match));
    
  }
}
void translateinfo::debuginfo(){
  map<String, trans_map, less<String> >::iterator i;
  trans_map::iterator j;
  for(i=trans.begin(); i!=trans.end(); i++){
    config.report(String("TRANS: [")+(*i).first+"]",
		  configinfo::report_debug);
    for(j=(*i).second.begin();
	j!=(*i).second.end();
	j++){
      config.report(String("key=")+(*j).first+
		    (*j).second->debuginfo()+"\n",
		    configinfo::report_debug);
      
      
    }
  } 
}
/////////////////////////////////////////////////////
//  Installed Package Status:
//

void read_pkginfo (void)
{
  FILE *status;
  char tmp[MAX_LINE];
  char *getselections=
    "dpkg --get-selections|sed -n -e 's/[ \t]*\\(install\\|hold\\)$//p'";

  status=popen(getselections,"r");

  if(!status)
    throw pipeerror_read(getselections);

  config.report(String("Reading installed packages..."),
		configinfo::report_verbose);
  while (!feof (status)){
    fgets (tmp, MAX_LINE, status);
    if(tmp[strlen(tmp)-1]=='\n')
      tmp[strlen(tmp)-1]=0;
    installed_packages.insert(tmp);
  }
  pclose (status);
}

void read_menufile(const String &filename,
		   const String &shortfilename,
		   vector<String> &menudata){
  bool wrote_filename=false;
  parsestream *i;
  procbuf pr;
  istream *pipe_istr=NULL;
  int linenr=1;

  config.report(String("Reading menuentryfile ")+filename,
		configinfo::report_debug);
  try{
    if(executable(filename)){
      pr.open(filename.c_str(),ios::in);
      pipe_istr=new istream(&pr);
      try{
	i=new parsestream(*pipe_istr);
      } catch (endoffile d){
	cerr<<"Error (or no input available from stdout) while executing "<<endl
	    <<filename<<" . Note that it is"<<endl
	    <<"a _feature_ of menu that it executes menuentryfiles that have"<<endl
	    <<"the executable bit set. See the documentation."<<endl;
	throw endoffile(d);
      }
    }
    else
      i=new parsestream(filename);
  } catch(endoffile p){
    return;
  }

  try{
    // Set compat mode:
    i->seteolmode(config.compat);

    while(true){//i->good()){
      try{
	menuentry m(*i,shortfilename);
	linenr++;
	if(transinfo)
	  transinfo->process(m);
	//gettext_translate(m);
	if(!wrote_filename){
	  menudata.push_back(String("!F ") + filename + "\n");
	  wrote_filename=true;
	}
	m.output(menudata);
	if(i->linenumber() != linenr){
	  menudata.push_back(String("!L ") + itoString(i->linenumber())+ "\n");
	  linenr=i->linenumber();
	}
      }
      catch(cond_inst_false){}
    }
  }
  catch(endoffile p){
    if(executable(filename)){
      if(pipe_istr)
	delete pipe_istr;
      pr.close();
    }
    delete i;
  }
}

void read_menufilesdir(vector<String> &menudata){
  
  struct stat st;
  DIR *dir;
  struct dirent *entry;
  int r;
  String name;
  String dummy;
  cStrVec::iterator method_i;
  String dirname;

  for(method_i=config.menufilesdir.begin();
      method_i!=config.menufilesdir.end();
      method_i++){
    dirname=(*method_i);
    config.report(String("Reading menuentryfiles in ")+dirname,
		  configinfo::report_verbose);
    try{
      dir=open_dir_check(dirname);
      while((entry=readdir(dir))){
	name=String(entry->d_name);
	if((name!=String("README"))&&(name!=String("core"))&&(name[0]!='.')&&
	   (name.find(".bak")==string::npos)&&
	   (!name.contains(String("menu.config")))&&
	   (name[name.length()-1]!='~'))
	  if(menufiles_processed.find(name)==menufiles_processed.end()){
	    menufiles_processed.insert(name);
	    name=dirname+name;
	    r=stat(name.c_str(),&st);
	    if((!r)&&(S_ISREG(st.st_mode)||S_ISLNK(st.st_mode)))
	      read_menufile(name,entry->d_name,
			    menudata);
	  }
	
      }
    } catch (dir_error_read p){dummy=p.name;}
  }
}

void run_menumethod(String methodname,
		    const vector<String> &menudata){
  const char *str;
  int fds[2];
  const vector<String> *md;
  const char *args[]={methodname.c_str(), "-f", "--stdin", NULL, NULL};
  unsigned int i;
  pid_t child, r;
  int status, ret;

  md=&menudata;
  config.report(String("Running method:")+methodname,
		configinfo::report_verbose);  
  
  ret=pipe(fds);
  if(ret==-1){
    config.report(String("Cannot create pipe"),
		  configinfo::report_quiet);  
    exit(1);
  }
  if(!(child=fork())){
    //child:
    close(fds[1]);
    close(0);
    dup(fds[0]);
    
    //???
    // The next 2 lines seem strange! But if I leave it out,
    // pipes (in commands executed in the /etc/menu-method/* scripts as
    // postrun etc) don't work when ran from dpkg. (When run from dpkg,
    // we elsewhere close all filedescriptors. And apparently
    // we need STDOUT open somehow in order to make the pipes work.
    close(1);
    dup(fds[0]); 
    execve(args[0],(char **)args, NULL);
    exit(1);
  } else {
    //parent:
    signal(SIGPIPE,SIG_IGN);
    close(fds[0]);
    for(i=0;i!=md->size();i++){
      str=(*md)[i].c_str();
      write(fds[1],str,strlen(str));
    }
    close(fds[1]);
    r=wait4(child,&status, 0, NULL);
    signal(SIGPIPE,SIG_DFL);
  }
  if(r==-1)
    config.report(String("Script ")+methodname+" could not be executed.",
		  configinfo::report_quiet);  
  if(WEXITSTATUS(status))
    config.report(String("Script ")+methodname+" returned error status "
		  +itoString(WEXITSTATUS(status))+".",
		  configinfo::report_quiet);  
  else if(WIFSIGNALED(status))
    config.report(String("Script ")+methodname+" recieved signal "
		  +itoString(WTERMSIG(status))+".",
		  configinfo::report_quiet);  
}

void run_menumethoddir (const String &dirname,
			const vector<String> &menudata){
  struct stat st;
  DIR *dir;
  struct dirent *entry;
  char *s, tmp[MAX_LINE];
  int r;

  config.report(String("Running menu-methods in ")+dirname,
		configinfo::report_verbose);
  dir=open_dir_check(dirname);
  while ((entry = readdir (dir)) != NULL){
    if (!strcmp(entry->d_name, "README") ||
	!strcmp(entry->d_name, "core"))
      continue;
    for (s = entry->d_name; *s != '\0'; s++){
      if (!(isalnum (*s) || (*s == '_') || (*s == '-')))
	break;
    }
    if (*s != '\0')
      continue;
    
    sprintf (tmp, "%s/%s", dirname.c_str(), entry->d_name);
    r=stat (tmp, &st);
    
    // Do we have execute permissions? 
    if ((!r)&&
	(((st.st_mode & S_IXOTH) || 
	  ((st.st_mode & S_IXGRP) && st.st_gid == getegid ()) || 
	  ((st.st_mode & S_IXUSR) && st.st_uid == geteuid ())) && 
	 (S_ISREG(st.st_mode) || S_ISLNK(st.st_mode))))
      run_menumethod(tmp,menudata);
  }
  closedir (dir);
}

int create_lock(){
  // return lock fd if succesful, false if unsuccesfull.
  int fd=true;
  
  if(!getuid()){
    fd=open(UPMEN_LOCKFILE,O_WRONLY|O_CREAT,00644);
    
    if(flock(fd,LOCK_EX|LOCK_NB)){
      if(errno==EWOULDBLOCK){
	config.report(String("Other update-menus processes are already "
			     "locking " UPMEN_LOCKFILE ", quitting."),
		      configinfo::report_verbose);
      }else{
	config.report(String("Cannot lock "UPMEN_LOCKFILE": ")+
			     strerror(errno)+ " Aborting.",
		      configinfo::report_quiet);	
      }
      return false;
	
    }

    ofstream of(fd);
    of<<getpid();
    if(!of.good()){
      config.report("cannot write to lockfile "
		    UPMEN_LOCKFILE". Aborting.",
		    configinfo::report_quiet);
      return false;
    }
  }
  return fd;
}

void remove_lock(){
  if(!getuid()){
    if(unlink(UPMEN_LOCKFILE))
      config.report("Cannot remove lockfile "UPMEN_LOCKFILE,
		    configinfo::report_normal);
  }
}

int check_dpkglock(){
  //return 1 if DPKG_LOCKFILE is locked and we should wait
  //return 0 if we don't need to wait (not root, or no dpkg lock)
  int fd;
  struct flock fl;
  char buf[MAX_LINE];
  if(getuid()){
    config.report("update-menus run by user -- cannot determine if dpkg is "
		  "locking "DPKG_LOCKFILE": assuming there is no lock",
		  configinfo::report_verbose);
    
    return 0;
  }
  fd=open(DPKG_LOCKFILE, O_RDWR|O_CREAT|O_TRUNC, 0660);
  if(fd==-1)
    return 0; // used to be 1, but why??? (Should not happen, anyway)
  fl.l_type= F_WRLCK;
  fl.l_whence= SEEK_SET;
  fl.l_start= 0;
  fl.l_len= 1;
  if (fcntl(fd,F_SETLK,&fl) == -1) {
    close(fd);
    if (errno == EWOULDBLOCK || errno == EAGAIN || errno == EACCES)
      return 1;
    cerr<<"update-menus: Encountered an unknown errno (="
	<<errno<<")."<<endl
	<<"update-menus: Could you please be so kind as to email joostje@debian.org"<<endl
	<<"update-menus: the errno (="<<errno<<") with a discription of what you did to"<<endl
	<<"update-menus: trigger this. Thanks very much."<<endl
	<<"Press enter"<<endl;
    cin.get(buf,sizeof(buf));
    return 1;
  }
  fl.l_type= F_UNLCK;
  fl.l_whence= SEEK_SET;
  fl.l_start= 0;
  fl.l_len= 1;
  if (fcntl(fd,F_SETLK,&fl) == -1){
    // `cannot happen'
    cerr<<"update-menus: ?? Just locked the dpkg status database to see if another dpkg"<<endl
	<<"update-menus: Was running. Now I cannot unlock it! Aborting"<<endl;
    exit(1);
  }
  close(fd);
  return 0;
}

void exit_on_signal(int signr){
  exit(0);
}

void wait_dpkg(String &stdoutfile){
  int child;
  int parentpid;
  int i,r;

  // This function checks to see if dpkg is running, and if
  // so, forks into the background, to let dpkg go on installing
  // packages. After dpkg finished (and wrote the new packages file),
  // this function wakes up, and returns.
  
  // Writing the console output correctly is actually non-trivial.
  // The problem is that we in the following if statement
  //     if(child=fork())
  //       exit(0);                            //parent process
  //     else
  //       do something (and write to stdout); //child `background' process
  // want to write to stdout. But if we write to stdout there,
  // the exit(0) may already have occured, and dpkg may already
  // have started writing stuff to the console. To prevent that,
  // I use signals: the `background' process sents a signal to the
  // parent once it's written everything it wants to stdout,
  // and only after the parent receved the signal it wil exit(0);

  if(check_dpkglock()){
    sigset_t sig,oldsig;

    // Apparently libc2 on 2.0 kernels, with threading on, blocks
    // SIGUSR1. This blocking would be inhereted by children, so
    // as apt was compiled with -lpthread, this caused problems in 
    // update-menus. I now get rid of that by using
    //  - SIGUSR2 instead of SIGUSR1,
    //  - sigprocmask to unblock SIGUSR2.
    // Eighter one of those solutions should be enough, though.

    sigemptyset(&sig);
    sigaddset(&sig,SIGUSR2);
    sigprocmask(SIG_UNBLOCK,&sig,&oldsig);

    signal(SIGUSR2,exit_on_signal);
    parentpid=getpid();
    if((child=fork())){
      if(child==-1){
	perror("update-menus: fork");
	exit(1);
      }
      pause();
    } else {
      r=create_lock();
      if(r){
	stdoutfile=String("/tmp/update-menus.")+itoString(getpid());
	config.report("waiting for dpkg to finish (forking to background)\n"
		      "(checking " DPKG_LOCKFILE ")",
		      configinfo::report_normal);
	config.report(String("further output (if any) will appear in ")
		      +stdoutfile,
		      configinfo::report_normal);
	// Close all fd's except the lock fd, for daemon mode.
	for (i=0;i<32;i++) {
	  if (i != r)
	    close(i);
	}
	kill(parentpid, SIGUSR2);

	while(check_dpkglock())
	  sleep(2);
      } else {
	// Exit without doing anything. Kill parent too!
	kill(parentpid,SIGUSR2);
	exit(0);
      }
    }
  } else {
    create_lock();
    config.report("Dpkg not locking dpkg status area. Good.",
		  configinfo::report_verbose);
  }
}

void parse_params(char **argv){
  while(*(++argv)){
    if(String("-d")==String(*argv))
      config.set_verbosity(configinfo::report_debug);
    if(String("-v")==String(*argv))
      config.set_verbosity(configinfo::report_verbose);
    if(String("--nodefaultdirs")==String(*argv))
      config.usedefaultmenufilesdirs=false;
    if(String("--menufiledir")==String(*argv)){
      argv++;
      if(*argv)
	(config.menufilesdir).push_back(String(*argv));
      else{
	cerr<<_("directory expected after --menufilesdir option")<<endl;
	throw informed_fatal();
      }
    }
    if(String("--menumethod")==String(*argv)){
      argv++;
      if(*argv)
	config.menumethod=String(*argv);
      else{
	cerr<<_("filename expected after --menumethod option")<<endl;
	throw informed_fatal();
      }
    }
    if(String("-h")==String(*argv)){
      cerr<<
	_("update-menus: update the various window-manager config files (and\n"
	  "  dwww, and pdmenu) Usage: update-menus [options] \n"
	  "    -v  be verbose about what is going on\n"
	  "    -d  debugging (loads of unintelligible output)")<<endl;
	exit(1);
    }
  }
}

void read_userconfiginfo(){
  //Because of gcc-2.7.2.1 internal compiler errors, had to split this up.
  //(well, not sure of the configinfo stuff, but translateinfo failed)
  if(getuid()){
    try{
      config.update(String(getenv("HOME"))+"/"+USERCONFIG);
    } catch(ferror_open d){};
  };
}

void read_rootconfiginfo(){
  if(!transinfo){
    try{
      config.update(CONFIG_FILE);
    } catch (ferror_open d){};
  }
}

void read_usertranslateinfo(){
  //Because of gcc-2.7.2.1 internal compiler errors, had to split this up.
  if(getuid()){
    try{
      transinfo=new translateinfo(String(getenv("HOME"))+"/"+USERTRANSLATE);
    } catch(ferror_open d){};
  };
}

void read_roottranslateinfo(){
  if(!transinfo){
    try{
      transinfo=new translateinfo(TRANSLATE_FILE);
    }catch (ferror_open d){};
  }
}

int main (int, char **argv){
  vector<String> menudata;
  String dummy;
  String stdoutfile;
  struct stat st;
  int r;

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);


  debug=0;
  try{
    //  read_userconfiginfo();
    read_rootconfiginfo();
    parse_params(argv);
    wait_dpkg(stdoutfile);
    if(stdoutfile.length()){
      close(1);
      open(stdoutfile.c_str(),
	   O_WRONLY|O_CREAT|O_SYNC|O_EXCL, 0666);
      close(2);
      dup2(1,2);
    }
    read_pkginfo();
    transinfo=NULL;

    read_usertranslateinfo();
    read_roottranslateinfo();
    if(transinfo)
      transinfo->debuginfo();
    if(config.usedefaultmenufilesdirs){
      if(getuid())
	(config.menufilesdir).push_back(String(getenv("HOME"))+
					"/"+USERMENUS);
      (config.menufilesdir).push_back(String(CONFIGMENUS));
      (config.menufilesdir).push_back(String(PACKAGEMENUS));
      (config.menufilesdir).push_back(String(MENUMENUS));
    }
    
    read_menufilesdir(menudata);
    
    if(config.menumethod.length())
      run_menumethod(config.menumethod,menudata);
    else{
      if(getuid()){
	try{
	  run_menumethoddir(String(getenv("HOME"))+"/"+USERMETHODS,
			    menudata);
	}
	catch(dir_error_read d){
	  dummy=d.name;
	  run_menumethoddir(MENUMETHODS, menudata);	
	}
      } else
	run_menumethoddir(MENUMETHODS, menudata);
    }
  }
  catch(genexcept& p){p.report();}
  /*  catch(except_String& p){p.report();}
  catch(except_pi& p){p.report();}
  catch(unknown_cond_package p){  p.report(); }
  catch(informed_fatal p){};
  */
  /*  catch(endoffile p){        p.report(cerr); }
  catch(endofline p){        p.report(cerr); }
  catch(char_expected p){    p.report(cerr); }
  catch(char_unexpected p){  p.report(cerr); }
  catch(def_error p){        p.report(cerr); }
  catch(unknown_compat p){   p.report(cerr); }

  */
  //  catch (ferror_read f){
  //    cerr<<"Cannot open file "<<f.name<<" for reading"<<endl;
  //  }
  //  catch (dir_error_read d){
  //    cerr<<"Cannot open directory "<<d.name<<" for reading"<<endl;
  //  }
  //catch (informed_fatal){
  //  cerr<<"Aborting."<<endl;
  //  }

  remove_lock();

  if(stdoutfile.length()){
    r=stat(stdoutfile.c_str(),&st);
    if(!r)
      if(!st.st_size)
	unlink(stdoutfile.c_str());
  }
  return 0;
}
