/*
 * tools/lib/lv_write_all_pv.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March 1997
 * August 1998
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

#include <liblvm.h>


int lv_write_all_pv ( vg_t *vg, int l) {
   int p = 0;
   int ret = 0;

#ifdef DEBUG
   debug ( "lv_write_all_pv -- CALLED with l: %d\n", l);
#endif

   if ( vg == NULL) return -LVM_EPARAM;

   for ( p = 0; p < vg->pv_cur; p++)
      if ( ( ret = lv_write ( vg->pv[p]->pv_name, vg, vg->lv[l], l)) < 0)
         break;

#ifdef DEBUG
   debug ( "lv_write_all_pv -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
