#pragma interface
#ifndef DAEMONI_H
#define DAEMONI_H

#ifndef MISC_H
	#include <misc.h>
#endif

//#ifndef NETCONF_H
//	#include "netconf.h"
//#endif

// Information on a process ID
class PROC{
	PROC *next;
	int pid;
	int ppid;		// Parent process ID
	char *path;		// Path of the program
	char *name;		// Pointer into path
	/*~PROTOBEG~ PROC */
public:
	PROC (int _pid, PROC *_next);
	const char *getname (void);
	PROC *getnext (void);
	const char *getpath (void);
	int getpid (void);
	int getppid (void);
	long getstarttime (void);
	int isok (void);
	int kill (int signo);
	~PROC (void);
	/*~PROTOEND~ PROC */
};

/*
	Control the startup of daemons
*/
class COMMAND: public ARRAY_OBJ{
public:
	SSTRING path;
	SSTRING args;
	char path_ok;	// Is the path for this command ok ?
	char path_checked;// (We don't wan't to hammer the user all the time
						//  if a daemon is missing)
	short timeout;	// Maximum normal execution time of the command
					// or daemon activation
	CONFIG_FILE *pidfile;
	/*~PROTOBEG~ COMMAND */
public:
	COMMAND (const char *line);
	COMMAND (void);
	int checkpath (bool&config_needed);
	PROC *findprocess (void);
private:
	void init (const char *line);
public:
	int kill (int signal_num);
	void reinit (const SSTRING&line);
	int signal (int signal_num,
		 const char *msg,
		 const char *sem_file);
	int system (const char *cmd);
	int system (void);
	/*~PROTOEND~ COMMAND */
};


class DAEMON: public ARRAY_OBJ{
public:
	SSTRING name;
	/*~PROTOBEG~ DAEMON */
public:
	DAEMON (void);
	void delrestarttime (void);
	virtual PROC *findprocess (bool&problem);
	const char *getlastargs (void);
	const char *getname (void);
	long getrestarttime (void);
	void recordargs (const char *args);
	virtual int restart (void);
	void setrestarttime (void);
	virtual int start (void);
	virtual int startif (void);
	int startif_date (long date);
	int startif_file (const CONFIG_FILE&cfile);
	int startif_file (const SSTRINGS&files);
	int startif_file (const char *fname);
	virtual int stop (void);
	/*~PROTOEND~ DAEMON */
};



// Components with builtin rules, unlike dropins
class DAEMON_INTERNAL: public DAEMON{
public:
	DAEMON_INTERNAL *next;
	COMMAND cmd;
	char managed;
	char override;	// Path or argument has been changed by the admin
					// and must be saved in /etc/conf.linuxconf
						
	/*~PROTOBEG~ DAEMON_INTERNAL */
public:
	DAEMON_INTERNAL (void);
	int checkpath (void);
	int edit (void);
	PROC *findprocess (bool&problem);
	const char *getargs (void);
	DAEMON_INTERNAL *getnext (void);
	const char *getpath (void);
	int gettimeout (void);
	void init (int _managed,
		 const char *_name,
		 const char *buf,
		 DAEMON_INTERNAL *_next);
	int is_managed (void);
	int is_overriden (void);
	int isok (void);
	void set_managed (int _managed);
	void set_override (int _over);
	void setargs (const char *args);
	void setpidfile (CONFIG_FILE *_pidfile);
	void setspec (const char *_path,
		 const char *_args);
	void settimeout (int nbsec);
	int signal (int signal_num,
		 const char *msg,
		 const char *sem_file);
	int signal (int signal_num, const char *msg);
	int start (void);
	int stop (void);
	/*~PROTOEND~ DAEMON_INTERNAL */
};

#endif

