#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <misc.h>
#include "internal.h"
#include "uucp.h"
#include "uucp.m"
#include "../paths.h"
#include <netconf.h>
#include <dialog.h>

static UUCP_HELP_FILE help_devices ("devices");
static CONFIG_FILE f_devices (VAR_LIB_UUCP_DEVICES
	,help_devices
	,CONFIGF_OPTIONNAL|CONFIGF_MANAGED
	,"uucp","uucp",0660,subsys_uucp);


PUBLIC DEVICE::DEVICE ()
{
	speed = 38400;
}

static const char *device_copycond (
	SSTRING &dst,
	const char *buf)
{
	buf = dst.copyword (buf);
	if (dst.cmp("-")==0) dst.setfrom ("");
	return buf;
}

PUBLIC DEVICE::DEVICE (
	const char *buf,	// Buffer to parse from the Permissions file
	const SSTRING &_comments,	// Comments preceding the definition
	char *err)			// Will contain error message or '\0'
{
	comments.setfrom (_comments);
	comments.strip_end();
	err[0] = '\0';
	buf = device_copycond (acu,buf);
	buf = device_copycond (device,buf);
	buf = device_copycond (device2,buf);
	char word[100];
	buf = str_copyword (word,buf,sizeof(word));
	speed = atoi(word);
	buf = device_copycond (type,buf);
	options.copyword (buf);
}

static void device_writecond(SSTRING &s, FILE *fout)
{
	const char *str = s.get();
	if (str[0] == '\0') str = "-";
	fprintf (fout,"%s ",str);
}
/*
	Write one record in the Permissions file
*/
PUBLIC void DEVICE::write (FILE *fout)
{
	comment_write (comments,fout);
	device_writecond (acu,fout);
	device_writecond (device,fout);
	device_writecond (device2,fout);
	fprintf (fout,"%d ",speed);
	device_writecond (type,fout);
	fprintf (fout,"%s\n",options.get());
}

static void serial_setfield (
	SSTRING &device,
	DIALOG &dia)
{
	FIELD_COMBO *comb = dia.newf_combo  (MSG_U(F_SERIALDEF
		,"Serial device"),device);
	comb->addopt ("/dev/cua0",MSG_U(F_FIRSTCOM,"first standard serial port COM1"));
	comb->addopt ("/dev/cua1",MSG_U(F_SECONDCOM,"Second standard serial port COM2"));
	comb->addopt ("/dev/ttyS0",MSG_U(F_COM1M,"COM1 when using mgetty"));
	comb->addopt ("/dev/ttyS1",MSG_U(F_COM2M,"COM2 when using mgetty"));
}
/*
	Add a baud rate field in a dialog with standard values
*/
void baud_setfield (
	int baud,
	SSTRING &baudstr,
	DIALOG &dia)
{
	char msg[10];
	baudstr.setfrom (baud);
	FIELD_COMBO	*comb = dia.newf_combo (MSG_U(F_BAUD,"Baud rate"),baudstr);
	static short int tb[]={
		3,6,12,24,48,96,
		192,384,576,1152
	};
	for (unsigned i=0; i<sizeof(tb)/sizeof(tb[0]); i++){
		sprintf (msg,"%d00",tb[i]);
		comb->addopt (msg);
	}
}

/*
	Return -1 if escape
	Return  0 if accept the changes
	Return  1 if the record must be deleted
*/
PUBLIC int DEVICE::edit (const DIALERS &dial)
{
	int ret = -1;
	DIALOG dia;
	FIELD_COMBO *comb = dia.newf_combo (MSG_R(F_TYPE),acu);
	comb->addopt ("ACU",MSG_R(M_MODEM));
	comb->addopt ("Direct",MSG_R(M_DIRECT));
	comb->addopt ("TCP",MSG_R(M_UUCPTCP));
	serial_setfield (device,dia);
	SSTRING baudstr;
	baud_setfield (speed,baudstr,dia);
	comb = dia.newf_combo (MSG_U(F_MODEMTYPE,"Modem type"),type);
	for (int i=0; i<dial.getnb(); i++){
		DIALER *d = dial.getitem(i);
		comb->addopt (d->type.get());
	}
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (
			MSG_U(T_DEVICE,"Uucp device configuration")
			,MSG_U(I_DEVICE,"You must specify the speed range\n"
				"and the modem type associated with a serial\n"
				"device.")
			,help_devices
			,nof
			,MENUBUT_CANCEL|MENUBUT_DEL|MENUBUT_ACCEPT);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_DEL){
			ret = 1;
			break;
		}else if (code == MENU_ACCEPT){
			ret = 0;
			break;
		}
	}
	if (ret != 0) dia.restore();
	return ret;
}


PUBLIC DEVICES::DEVICES()
	: CONFIG_OBJS (f_devices)
{
}

PUBLIC DEVICE *DEVICES::getitem(int no)
{
	return (DEVICE*)ARRAY::getitem(no);
}

PROTECTED CONFIG_OBJ *DEVICES::newobj (
	const char *buf,	// Buffer to parse from the Permissions file
	const SSTRING &_comments,	// Comments preceding the definition
	char *err)			// Will contain error message or '\0'
{
	return new DEVICE (buf,_comments,err);
}

static int cmp_by_name (const ARRAY_OBJ *o1, const ARRAY_OBJ *o2)
{
	DEVICE *s1 = (DEVICE*)o1;
	DEVICE *s2 = (DEVICE*)o2;
	int ret = s1->acu.cmp(s2->acu);
	if (ret == 0){
		ret = s1->device.cmp(s2->device);
	}
	return ret;
}

PUBLIC void DEVICES::sort()
{
	ARRAY::sort (cmp_by_name);
}


PUBLIC int DEVICES::edit()
{
	DIALERS dial;
	dial.read();
	while (1){
		DIALOG dia;
		int n = getnb();
		sort();
		for (int i=0; i<n; i++){
			DEVICE *s = getitem(i);
			char buf[100];
			sprintf (buf,"%-15s %s",s->device.get(),s->type.get());
			dia.new_menuitem (s->acu.get(),buf);
		}
		dia.addwhat (MSG_R(I_ADDSYS));
		int sel;
		MENU_STATUS code = dia.editmenu (
			MSG_U(T_DEVICES,"Edit uucp devices configuration")
			,MSG_U(I_DEVICES
			 ,"Each configuration control an uucp device\n"
			  "and the way this device (modem) is\n"
			  "initialised/dialed\n")
			,help_devices
			,sel,0);
		if (code == MENU_OK){
			if (n > 0){
				DEVICE *s = getitem(sel);
				int ok = s->edit(dial);
				manage_edit (s,ok);
			}
		}else if (code == MENU_ESCAPE || code == MENU_QUIT){
			break;
		}else if (code == MENU_ADD){
			DEVICE *s = new DEVICE;
			int code = s->edit(dial);
			manage_edit (s,code);
		}
	}
	return 0;
}

void devices_edit()
{
	DEVICES dev;
	dev.read();
	dev.edit();
}


