#!/bin/sh
# Extract the file received from the administration server
# and send them on stdout so linuxconf can install those file
# in the current configuration.
if [ $# != 3 ] ; then
	echo netadmextract.sh admin_group path_file family
	echo The last argument is not used
else
	ADMIN=$1	
	FILE=$2
	BASE=/etc/linuxconf/admgroups/$ADMIN
	TARGET=$BASE/$FILE
	DIR=`dirname $TARGET`
	if [ -f $TARGET ] ; then
		cat $TARGET
	else
		# This tells linuxconf that the file was never
		# archived so it is better to leave the current copy in place
		echo "### no arch ###"
	fi
fi

