#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#ifndef MISC_H
	#include <misc.h>
#endif

class MAILCONF_HELP_FILE: public HELP_FILE{
	/*~PROTOBEG~ MAILCONF_HELP_FILE */
public:
	MAILCONF_HELP_FILE (const char *fname);
	/*~PROTOEND~ MAILCONF_HELP_FILE */
};


// Special case where we dictate to sendmail which forwarding host to use
class SPC_ROUTE: public ARRAY_OBJ{
public:
	SSTRING to;		// Destination of the mail
	SSTRING mailer;		// mailer used to reach the forwarder
	SSTRING forwarder;
	char subdomain;		// Deliver to subdomain also
	/*~PROTOBEG~ SPC_ROUTE */
public:
	SPC_ROUTE (void);
	int edit (void);
	void write (FILE *fout);
	/*~PROTOEND~ SPC_ROUTE */
};

class SPC_ROUTES: public ARRAY{
	/*~PROTOBEG~ SPC_ROUTES */
public:
	SPC_ROUTES (void);
	int build (void);
	int edit (void);
	SPC_ROUTE *getitem (int no);
	int save (void);
	void sort (void);
	/*~PROTOEND~ SPC_ROUTES */
};
class VDOMAINS;
class MASQ: public ARRAY_OBJ{
public:
	char active;
	SSTRING from;
	SSTRING new_from;
	SSTRING mailer;
	SSTRING comment;
	/*~PROTOBEG~ MASQ */
public:
	MASQ (const char *buf);
	MASQ (void);
	int edit (void);
	int rule1 (FILE *fout, char *status);
	/*~PROTOEND~ MASQ */
};

class MASQS: public ARRAY{
	/*~PROTOBEG~ MASQS */
public:
	MASQS (void);
	int edit (void);
	MASQ *getitem (int no);
	int rule1 (FILE *fout);
	int write (void);
	/*~PROTOEND~ MASQS */
};



class COMPLEX_ROUTE: public ARRAY_OBJ{
public:
	char active;
	SSTRING from;
	SSTRING to;
	SSTRING router;
	SSTRING mailer;
	SSTRING new_from;
	SSTRING new_to;
	SSTRING comment;
	/*~PROTOBEG~ COMPLEX_ROUTE */
public:
	COMPLEX_ROUTE (const char *buf);
	COMPLEX_ROUTE (void);
	int edit (void);
	bool isuserroute (void);
	int rule0 (FILE *fout,
		 char *status,
		 SSTRINGS *aliases,
		 VDOMAINS *vdomains);
	/*~PROTOEND~ COMPLEX_ROUTE */
};

class COMPLEX_ROUTES: public ARRAY{
	/*~PROTOBEG~ COMPLEX_ROUTES */
public:
	COMPLEX_ROUTES (void);
	int edit (void);
	COMPLEX_ROUTE *getitem (int no);
	int rule0 (FILE *fout,
		 SSTRINGS&aliases,
		 VDOMAINS&vdomains);
	int write (void);
	/*~PROTOEND~ COMPLEX_ROUTES */
};

class USERS;
class CONFIG_FILE;
class VDOMAINS;
class VDOMAIN: public ARRAY_OBJ{
public:
	SSTRING domain;		// Fully qualified name of the domain
	SSTRINGS faliases;	// Path of the alternate aliases files
	SSTRINGS others;	// Others name for the domain
	SSTRING fallback;	// Where to send email when the target account
						// does not exist
	SSTRING filter;		// Filter program and args for delivery
	int startuid;
	int quota;
	char match_gecos;
	/*~PROTOBEG~ VDOMAIN */
public:
	VDOMAIN (const char *line);
	VDOMAIN (void);
private:
	void addother (DIALOG&dia);
public:
	void createfiles (void);
	int edit (VDOMAINS&vs);
	USERS *getusers (CONFIG_FILE *&file,
		 CONFIG_FILE *&file_shadow);
	void setpwdpaths (char *pwdfile,
		 char *shadowfile,
		 char *pathhome,
		 char *root);
	void setupdia (DIALOG&dia);
private:
	void showother (DIALOG&dia, int item);
public:
	/*~PROTOEND~ VDOMAIN */
};
class FIXPERM_SPECS;

class VDOMAINS: public ARRAY{
	/*~PROTOBEG~ VDOMAINS */
public:
	VDOMAINS (void);
	int checkperm (bool, bool);
	int edit (void);
	VDOMAIN *getitem (const char *domain);
	VDOMAIN *getitem (int no);
	void listperm (FIXPERM_SPECS&specs);
	VDOMAIN *locate (const char *domain);
	VDOMAIN *lookup (const char *str);
	MENU_STATUS select (const char *title,
		 const char *intro,
		 int mayadd,
		 int &nof);
	void sort (void);
	int write (void);
	/*~PROTOEND~ VDOMAINS */
};

class FAXRULE: public ARRAY_OBJ{
	friend class FAXRULES;
	SSTRING id;
	char origin;	// Access controled by the source of the email
	char user;		// Type of user accepted
	char pgp;		// PGP is required
	SSTRINGS users;
	/*~PROTOBEG~ FAXRULE */
public:
	FAXRULE (CONFDB&db, const char *id);
	FAXRULE (void);
	int edit (void);
	const char *getid (void);
private:
	void init (void);
public:
	void write (CONFDB&db);
	/*~PROTOEND~ FAXRULE */
};

class FAXRULES: public ARRAY{
	/*~PROTOBEG~ FAXRULES */
public:
	FAXRULES (void);
	int edit (void);
	FAXRULE *getitem (int no);
	int write (void);
	/*~PROTOEND~ FAXRULES */
};

class FAXALIAS: public ARRAY_OBJ{
public:
	SSTRING alias;
	SSTRING name;
	SSTRING phone;
	SSTRING rule;
	/*~PROTOBEG~ FAXALIAS */
public:
	FAXALIAS (const char *buf);
	FAXALIAS (void);
	int edit (void);
	/*~PROTOEND~ FAXALIAS */
};
class FAXALIASES: public ARRAY{
	/*~PROTOBEG~ FAXALIASES */
public:
	FAXALIASES (void);
	int edit (void);
	FAXALIAS *getitem (int no);
	int write (void);
	/*~PROTOEND~ FAXALIASES */
};

class FAXZONE: public ARRAY_OBJ{
public:
	SSTRING id;
	SSTRING zone;
	int len;
	SSTRING rule;
	/*~PROTOBEG~ FAXZONE */
public:
	FAXZONE (const char *buf);
	FAXZONE (void);
	int edit (void);
private:
	void init (void);
public:
	/*~PROTOEND~ FAXZONE */
};
class FAXZONES: public ARRAY{
	/*~PROTOBEG~ FAXZONES */
public:
	FAXZONES (void);
	int edit (void);
	FAXZONE *getitem (int no);
	int write (void);
	/*~PROTOEND~ FAXZONES */
};
class FAXUSER: public ARRAY_OBJ{
public:
	SSTRING name;
	SSTRING email;
	SSTRING pgp;		// PGP signature
	/*~PROTOBEG~ FAXUSER */
public:
	FAXUSER (const char *buf);
	FAXUSER (void);
	int edit (void);
	/*~PROTOEND~ FAXUSER */
};

class FAXUSERS: public ARRAY{
	/*~PROTOBEG~ FAXUSERS */
public:
	FAXUSERS (void);
	int edit (void);
	FAXUSER *getitem (int no);
	int write (void);
	/*~PROTOEND~ FAXUSERS */
};
	

class MAILFAX{
public:
	char enable;
	SSTRING faxcmd;		// Path of the fax command (/usr/bin/spoolfax)
	SSTRING log;		// path of the optionnal log file
	SSTRING logcmd;		// path of the optionnal log file
	FAXRULES rules;
	FAXUSERS users;
	FAXALIASES aliases;
	FAXZONES zones;
	/*~PROTOBEG~ MAILFAX */
public:
	MAILFAX (void);
	int edit (void);
	int write (void);
	/*~PROTOEND~ MAILFAX */
};


#define MAXDNSFOR 5

class MAILCONF{
	char mainserv;		// Is this server the one which receive
						// email for the domain
	bool sendmail_cw;	// alias was read either from conf.linuxconf
						// or sendmail.cw
	SSTRINGS alias;
	SSTRING mailas;		// System name we are using
						// when mailing out
	SSTRING mailhost;	// We send all mail to this machine
						// including local one.
	SSTRING smarthost;	// We send what we can't resolve
	SSTRING smartmailer;	// Mailer used to send to smarthost
	struct {
		SSTRING dontmasque;	// Users which will never be
					// masquerade using mailas
		SSTRING deliverlocal;	// Users who received their
					// mail on this machine even
					// if we have a mailhost
		SSTRING trust;	// List of trust users
	} users;
	struct {
		char dnsneeded;		// Sendmail perform only if it can
							// find the DNS
		char nodns;			// Never use the DNS to canonify hostname
		char uucpnobatch;	// No -r option for uux
		char mailertable;	// Use /var/lib/mailertable or not
		char deferdeliv;	// Deferred delivery
		char bogushelo;		// Tolerant for flaky mail programs
		char usegecos;		// Allow sending mail to name in the GECOS
							// field
		char usesmrsh;		// Use smrsh as a shell
		char relayctrl;		// Enable relay control (anti-spam rules)
		SSTRING dbformat;	// format for mailertable
		int uucpmax;		// Maximum size of an UUCP mail.
		int queuedelay;		// Run the queue every X minutes
		int maxmsgsize;
		int maxrecipients;
	} features;
	SSTRINGS dnsfor;		// Use the DNS only for those domains
							// See the large comment about
							// DNS scope in basic.c
	SPC_ROUTES spcs;		// Special routes using mailertable
	COMPLEX_ROUTES cplxs;
	SSTRING deliver;		// Utility to deliver local mail
	MASQS masqs;
	MAILFAX mfax;
	/*~PROTOBEG~ MAILCONF */
public:
	MAILCONF (void);
	int basicedit (void);
	int check (VDOMAINS&vdoms);
private:
	int generate (FILE *fout);
public:
	int generate (bool confirm);
	int generate_go (bool confirm);
	int generate_if (bool confirm);
private:
	bool generated_byme (char sendmail_sum[]);
public:
	int getqueuedelay (void);
	void spcs_edit (void);
	int write (void);
	/*~PROTOEND~ MAILCONF */
};

extern const char subsys_mail[];
extern const char subsys_sendmail[];
extern const char subsys_relaycontrol[];

extern CONFIG_FILE f_spam_deny;
extern CONFIG_FILE f_spam_ip_allow;
extern CONFIG_FILE f_spam_name_allow;
extern CONFIG_FILE f_spam_relay_allow;
extern CONFIG_FILE f_mailtable;
extern CONFIG_FILE f_virtuser;
extern CONFIG_FILE f_pophash;

#endif

