/* ***********

	Check comments starting with // ### and fill appropriate code there

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <translat.h>
#include <netconf.h>
#include "dialout.h"
#include "dialout.m"

MODULE_DEFINE_VERSION(dialout);

PUBLIC MODULE_dialout::MODULE_dialout()
	: LINUXCONF_MODULE("dialout")
{
	linuxconf_loadmsg ("dialout",PACKAGE_REV);
	module_register_api ("fwinfo",1,dialout_fwinfo_api_get
		,dialout_fwinfo_api_release);
}


static const char *keymenu=NULL;
static const char *ppplink=NULL;

PUBLIC void MODULE_dialout::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_CLIENT){
		keymenu = MSG_U(M_dialout,"PPP or SLIP dialout");
		dia.new_menuitem ("ppp","",keymenu);
	}else if (context == MENU_CONTROL_PANEL){
		ppplink = MSG_U(M_PPPCTRL,"Activate/terminate PPP links");
		dia.new_menuitem ("","",ppplink);
	}
}

PUBLIC int MODULE_dialout::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_CLIENT){
		if (key == keymenu){
			ppp_edit();
		}
	}else if (context == MENU_CONTROL_PANEL){
		if (key == ppplink){
			ppp_control();
		}
	}
	return 0;
}


PUBLIC int MODULE_dialout::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"dialout")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module dialout\n"
		 "\n"
		 "    --dialctl\n"
		 "    --disconnect config\n"
		 "    --connect config [ --fore ]\n")
		);
}

static int dialout_main (int argc, char *argv[])
{
	int ret = 0;
	if (netconf_mainaccess()){
		if (argc == 1){
			ppp_edit();
		}else if (argc == 2){
			char *arg1 = argv[1];
			if (strcmp(arg1,"--dialctl")==0){
				/* #Specification: dialout / option / --dialctl
					netconf --dialctl presents a list of all available
					PPP/SLip dialout configuration in a menu
					and let the operator establish or terminate
					a connection. Normal privileges apply.
				*/
				ppp_control();
			}else{
				usage();
			}
		}else if (argc >= 3){
			char *arg1 = argv[1];
			if (strcmp(arg1,"--connect")==0){
				/* #Specification: netconf / option / --connect
					netconf --connect establish a PPP or SLIP
					connection to a preconfigured site.
				*/
				ret = ppp_connect (argc-2,argv+2);
			}else if (strcmp(arg1,"--disconnect")==0){
				/* #Specification: netconf / option / --disconnect
					netconf --disconnect terminate a PPP or SLIP
					connection.
				*/
				ret = ppp_disconnect (argc-2,argv+2);
			}else if (strcmp(arg1,"--postconnect")==0 && argc == 5){
				ret = ppp_postconnect (argc-2,argv+2);
			}else if (strcmp(arg1,"--predisconnect")==0 && argc == 5){
				ret = ppp_predisconnect (argc-2,argv+2);
			}else if (strcmp(arg1,"--setdevdef")==0){
				if (argc != 7){
					usage();
				}else if (getuid()!=0){
					fprintf (stderr,MSG_U(E_SETETH0DEF,"netconf --setdevdef can only be used by root\n"));
				}else{
					host_setdevdef (atoi(argv[2]),argv[3],argv[4],argv[5],argv[6]);
				}
			}else if (strcmp(arg1,"--setupdiald")==0){
				if (argc < 8){
					usage();
				}else{
					ret = diald_setroutes (argv[2],argv[3],argv[6],atoi(argv[7]));
				}
			}else{
				usage();
			}
		}else{
			usage();
		}
	}
	return ret;
}

PUBLIC int MODULE_dialout::message (const char *msg, int argc, const char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(msg,"dialoutmain")==0){
		ret = dialout_main (argc,(char**)argv);
	}else if (strcmp(msg,"bootcleanup")==0){
		ppp_bootcleanup();
		diald_bootcleanup();
		ret = 0;
	}
	return ret;
}

PUBLIC void MODULE_dialout::usage(SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_dialout::execmain (int argc , char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"dialout")==0){
		ret = dialout_main (argc,argv);
	}
	return ret;
}

PUBLIC int MODULE_dialout::probe (
	int level,	// Current level being probed
			// Only service of this level should do something.
	int target,	// target network runlevel of the probe
			// In which runlevel the machine is going to be
			// after the probe has completed
	bool)	// simulation mode ?
{
	if (level == 1 && target >= 1){
		ppp_start();
	}
	return 0;
}

static MODULE_dialout dialout;

