#include <stdio.h>
#include <string.h>
#include <translat.h>
#include <netconf.h>
#include "internal.h"
#include "apache.m"

MODULE_DEFINE_VERSION(apache);

PUBLIC MODULE_APACHE::MODULE_APACHE()
	: LINUXCONF_MODULE ("apache")
{
	linuxconf_loadmsg ("apache",PACKAGE_REV);
}
static const char *keymenu=NULL;

PUBLIC void MODULE_APACHE::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_SERVER){
		keymenu = MSG_U(M_APACHE,"Apache Web server");
		dia.new_menuitem ("apache","",keymenu);
	}
}

PUBLIC int MODULE_APACHE::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
		if (key == keymenu){
			httpd_edit();
		}
	}
	return 0;
}

PUBLIC void MODULE_APACHE::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_U(I_USAGE
		,"module apache\n"
		 "\n"
		 "    --help\n"
		 "    --addvhost hostname --root path\n"
		 "    --delvhost hostname\n"
		)));
}
static MODULE_APACHE apache;

#if 0
/*
	Restart httpd if HTTPD_CONF is newer than the process
*/
PUBLIC int DAEMON_HTTPD::startif ()
{
	/* #Specification: httpd / strategy
		httpd depends on /etc/httpd.conf.
		If the file is empty or do not exist, then httpd
		is not need. It will be killed, or not started.

		If httpd.conf is not empty, it will be started. If it is
		already running and httpd.conf is younger than the process,
		it will be kill and restart.

	*/
	extern CONFIG_FILE httpd_conf;
	return startif_file(httpd_conf);
}
#endif


static void usage ()
{
	fprintf (stderr,MSG_R(I_USAGE));
}

PUBLIC int MODULE_APACHE::execmain (int argc , char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"apache")==0){
		ret = -1;
		if (netconf_rootaccess()){
			if (argc == 1){
				httpd_edit();
				ret = 0;
			}else if (argc == 2 && strcmp(argv[1],"--help")==0){
				::usage();
			}else if (argc == 3 && strcmp(argv[1],"--delvhost")==0){
				vhostedit_del (argv[2]);
			}else if (argc > 2){
				if (strcmp(argv[1],"--addvhost")==0){
					vhostedit_add (argv[2],argc-3,(const char **)(argv+3));
				}else{
					::usage();
				}
			}else{
				::usage();
			}
		}
	}
	return ret;
}

