#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dialog.h>
#include "misc.h"
#include "misc.m"

/*
	Ask a question and return MENU_YES if the user answer yes.
	may Return MENU_NO or MENU_ESCAPE also
*/
MENU_STATUS xconf_yesno(
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile)	// Help file or help_nil
{
	dialog_clear();
	return dialog_yesno(title,prompt,helpfile);
}

/*
	Return != 0 if the user accept to quit anyway.
*/
int xconf_quitwosave()
{
	return xconf_yesno(MSG_U(T_QUIT,"Quit without saving ?")
		,MSG_U(I_QUIT,"You have modified the information somewhat\n"
		 "Are you sure you want to quit ?\n")
		,help_nil)==MENU_YES;
}
/*
	Return != 0 if the user confirm something.
*/
int xconf_areyousure(const char *msg)
{
	return xconf_yesno(MSG_U(T_AREYOUSURE,"Are you sure ?")
		,msg
		,help_nil)==MENU_YES;
}

/*
	Ask the user for a confirmation before deleting a record
	Return != 0 if ok.
*/
int xconf_delok()
{
	return xconf_areyousure(
		MSG_U(I_DELRECORD,"Are you sure you want to delete this record ?"));
}

