#include "diawxxt.h"
#include <MSC_timer.h>

class MFORM_TIMER: public wxTimer{
public:
	MFORM *target;
	int but;
	/*~PROTOBEG~ MFORM_TIMER */
public:
	MFORM_TIMER (MFORM *_target, int _but);
private:
	void Notify (void);
public:
	/*~PROTOEND~ MFORM_TIMER */
};


PUBLIC MFORM_C::MFORM_C(const char *_id)
{
	weightx = weighty = 0;
	h_align = ' ';
	v_align = 't';
	is_hcontrib = true;
	v_cells = h_cells = 1;
	s = NULL;
	c = NULL;
	id = strdup(_id);
	type = T_UNKNOWN;
	pref_width = pref_height = -1;
	homemade = false;
	radio = NULL;
}

PUBLIC void MFORM_C::sets (const char *str)
{
	free (s);
	s = strdup(str);
}

PUBLIC MFORM_C::~MFORM_C()
{
	free (id);
	free (s);
	delete radio;
}

PUBLIC MFORM::~MFORM()
{
	free (dispstr);
	//reset();
	free (sidetitle);
	delete timer;
}
// This is a checkbox which can be operated with other, creating
// radio buttons, but without any layout constraint
PRIVATE void MFORM::init()
{
	marge_gauche = marge_droite = marge_haut = marge_bas = 0;
	min_width = 0;
	dispstr = strdup("llllllllllllllllllllllllllllllllllllllllllllllllll");
	//setLayout(new mform_layout(this));
	sidetitle = NULL;
	vscroll = NULL;
	voffset = 0;
	timer = NULL;
	memset (mincols,0,sizeof(mincols));
	max_width = 2000;
	max_height = 300;
}
PUBLIC MFORM::MFORM (FORMBASE *_parent, const char *_id)
	: FORMBASE (_parent,_id)
{
	init();
}
// Constructor for MAINFORM
PROTECTED MFORM::MFORM (const char *_id)
	: FORMBASE (_id)
{
	init();
}
PUBLIC void MFORM::reset()
{
	int i;
	for (i=0; i<nbc; i++) delete tbc[i];
	nbc = 0;
	set_modified();
}

PUBLIC VIRTUAL void MFORM::Newline()
{
	MFORM_C *m = alloc_mf();
	m->type = T_NEWLINE;
}
// Affect the colspan and rowspan of the previously added dialog item
PUBLIC void MFORM::Dispolast(
	char h_align,	// Horizontal disposition 'l', 'c', 'r'
	int h_cells,
	char v_align,	// Vertical disposition 't', 'c', 'b'
	int v_cells)
{
	MFORM_C *m = tbc[nbc-1];
	m->h_align = h_align;
	m->h_cells = h_cells;
	m->v_align = v_align;
	m->v_cells = v_cells;
}
// Affect the weight (resizing importance) of the previously added item
// wx and wy are number >= 0. They are meaningless, except the
// available space will be given to dialog items according to their
// relative weight. A fixed item has 0,0
PUBLIC void MFORM::Setweightlast(int wx, int wy)
{
	MFORM_C *m = tbc[nbc-1];
	m->weightx = wx;
	m->weighty = wy;
}
PUBLIC VIRTUAL void MFORM::New_label(const char *str)
{
	MFORM_C *m = alloc_mf();
	m->type = T_LABEL;
	m->homemade = true;
	m->sets(str);
	Dispolast (' ',1,'c',1);
}
PUBLIC VIRTUAL void MFORM::New_richtext(const char *str)
{
	MFORM_C *m = alloc_mf();
	m->type = T_RICHTEXT;
	m->homemade = true;
	m->sets(str);
}
#if 0
PUBLIC VIRTUAL wxLabel *MFORM::New_wlabel(const char *str)
{
	MFORM_C *m = alloc_mf();
	wxLabel *ret = new wxLabel (str);
	m->c = ret;
	return ret;
}
#endif

PUBLIC VIRTUAL wxText *MFORM::New_string (
	const char *_id,
	int len,
	const char *initval)
{
	MFORM_C *m = alloc_mf(_id);
	m->sets(initval);
	wxText *ret = new wxText (this,NULL,NULL,initval,-1,-1,len*GetCharWidth());
	m->c = ret;
	m->type = T_STRING;
	return ret;
}

PUBLIC VIRTUAL wxText *MFORM::New_password (
	const char *_id,
	int)		// len
{
	MFORM_C *m = alloc_mf(_id);
	m->sets("");
	wxText *ret = new wxText (this,NULL,NULL,"",-1,-1,-1,-1,wxTE_PASSWORD);
	m->c = ret;
	m->type = T_STRING;
	return ret;
}
PUBLIC VIRTUAL wxText *MFORM::New_string (int len, const char *initval)
{
	return New_string ("",len,initval);
}

PUBLIC VIRTUAL wxMultiText *MFORM::New_text (
	const char *_id,
	int cols,
	int rows)
{
	MFORM_C *m = alloc_mf(_id);
	m->sets("");
	rows = (rows+1)*(int)GetCharHeight();
	cols = (cols+1)*(int)GetCharWidth();
	wxMultiText *ret = new wxMultiText (this,NULL,NULL,"",-1,-1,cols,rows
		,wxHSCROLL);
	m->c = ret;
	m->type = T_TEXT;
	return ret;
}

PUBLIC VIRTUAL wxSlider *MFORM::New_slider (
	const char *_id,
	int width,
	int minval,
	int maxval,
	int val)
{
	MFORM_C *m = alloc_mf(_id);
	wxSlider *ret = new wxSlider (this,NULL,NULL,val,minval,maxval,width);
	m->c = ret;
	m->type = T_SLIDER;
	return ret;
}

PUBLIC VIRTUAL wxGauge *MFORM::New_gauge (
	const char *_id,
	int width,
	int range,
	int val)
{
	MFORM_C *m = alloc_mf(_id);
	wxGauge *ret = new wxGauge (this,NULL,range,-1,-1,width);
	ret->SetValue (val);
	m->c = ret;
	m->type = T_GAUGE;
	return ret;
}


PUBLIC VIRTUAL void MFORM::Skip (int n)
{
	MFORM_C *m = alloc_mf();
	m->type = T_SKIP;
	m->h_cells = n;
}
PUBLIC VIRTUAL void MFORM::Fill ()
{
	MFORM_C *m = alloc_mf();
	m->type = T_FILL;
}
PUBLIC VIRTUAL void MFORM::New_hline (const char *s)
{
	MFORM_C *m = alloc_mf();
	m->c = new HLINE (this,s);
	m->type = T_HLINE;
	Dispolast ('l',1,'c',1);
}
PUBLIC VIRTUAL void MFORM::New_hline ()
{
	New_hline (NULL);
}
PUBLIC VIRTUAL void MFORM::New_vline ()
{
	MFORM_C *m = alloc_mf();
	m->type = T_VLINE;
}

PUBLIC void FORMBASE::report_button (
	const char *button_id,
	bool dodump,
	wxMouseEvent *event)
{
	int bstate = 0;
	if (event != NULL){
		if (event->ButtonDown(1)) bstate |= 1;
		if (event->ButtonDown(2)) bstate |= 2;
		if (event->ButtonDown(3)) bstate |= 4;
		if (event->controlDown) bstate |= 8;
		if (event->shiftDown) bstate |= 16;
		if (event->altDown) bstate |= 32; 
		if (event->metaDown) bstate |= 64;
	}
	char path[300];
	formbase_getabspath(this,path);
	remadmin_setcursor (cursor_wait);
	if (dodump){
		getlogicaltop()->dump();
	}
	fprintf (mform_fout,"action %s %s %d\n",path,button_id,bstate);
	fflush (mform_fout);
}
class MFORM_BUTTON: public wxButton{
public:
	bool dodump;
	/*~PROTOBEG~ MFORM_BUTTON */
public:
	MFORM_BUTTON (MFORM *_parent,
		 const char *str,
		 bool _dodump);
	MFORM_BUTTON (MFORM *_parent, wxBitmap *bitmap);
	/*~PROTOEND~ MFORM_BUTTON */
};

static void button_func (wxObject &o, wxCommandEvent &)
{
	extern FILE *ftty;
	if (ftty != NULL){
		fprintf (ftty,"button\n");
		fflush (ftty);
	}
	MFORM_BUTTON *b = (MFORM_BUTTON*)&o;
	FORMBASE *p = (FORMBASE*)b->GetParent();
	for (int i=0; i<p->nbc; i++){
		MFORM_C *c = p->tbc[i];
		if (c->c == b){
			p->report_button (c->id,b->dodump,NULL);
			break;
		}
	}
}

PUBLIC MFORM_BUTTON::MFORM_BUTTON(
	MFORM *_parent,
	const char *str,
	bool _dodump)
	: wxButton (_parent,button_func,(char*)str)
{
	dodump = _dodump;
}

PUBLIC MFORM_BUTTON::MFORM_BUTTON(MFORM *_parent, wxBitmap *bitmap)
	: wxButton (_parent,button_func,bitmap)
{
	dodump = false;
}

PUBLIC VIRTUAL wxButton *MFORM::New_button(
	const char *_id,
	bool dodump,
	const char *str)
{
	MFORM_C *m = alloc_mf(_id);
	wxButton *ret = new MFORM_BUTTON(this,str,dodump);
	m->c = ret;
	m->type = T_BUTTON;
	return ret;
}

PUBLIC VIRTUAL void MFORM::New_buttonfill(const char *_id, const char *str)
{
	MFORM_C *m = alloc_mf(_id);
	m->homemade = true;
	m->sets (str);
	m->type = T_BUTTONFILL;
}

PUBLIC VIRTUAL wxButton *MFORM::New_button(
	const char *_id,
	wxBitmap *bitmap)
{
	MFORM_C *m = alloc_mf(_id);
	wxButton *ret = new MFORM_BUTTON(this,bitmap);
	m->c = ret;
	m->type = T_BUTTON;
	return ret;
}

PUBLIC VIRTUAL void MFORM::New_icon_xpm(
	wxBitmap *bitmap)
{
	MFORM_C *m = alloc_mf();
	wxButton *ret = new wxButton(this,NULL,bitmap);
	m->c = ret;
	m->type = T_BUTTON;
}

PUBLIC VIRTUAL wxButton *MFORM::New_button(const char *str)
{
	return New_button ("",false,str);
}
PUBLIC VIRTUAL COMBO *MFORM::New_choice(const char *_id, const char *val)
{
	MFORM_C *m = alloc_mf (_id);
	COMBO *ret = new COMBO(this,val,20,true);
	m->c = ret;
	m->sets (val);
	m->type = T_COMBO;
	return ret;
}
PUBLIC VIRTUAL void MFORM::New_choice_item(
	const char *_id,
	const char *val1,
	const char *val2)
{
	for (int i=0; i<nbc; i++){
		MFORM_C *m = tbc[i];
		if (m->type == T_COMBO && strcmp(m->id,_id)==0){
			COMBO *c = (COMBO*)m->c;
			c->addItem(val1,val2);
			break;
		}
	}
}

PUBLIC VIRTUAL wxListBox *MFORM::New_list(
	const char *_id,
	int,				// nbvisible
	const char *val)
{
	MFORM_C *m = alloc_mf (_id);
	wxListBox *ret = new wxListBox (this,NULL,NULL);
	m->c = ret;
	m->sets(val);
	m->type = T_LIST;
	return ret;
}
PUBLIC VIRTUAL void MFORM::New_list_item(const char *_id, const char *val)
{
	for (int i=0; i<nbc; i++){
		MFORM_C *m = tbc[i];
		if (m->type == T_LIST && strcmp(m->id,_id)==0){
			wxListBox *c = (wxListBox*)m->c;
			c->Append((char*)val);
			if (strcmp(m->s,val)==0){
				//fprintf (stderr,"list :%s: :%s: %d %d\n",m->s,val,strcmp(m->s,val),c->Number());
				// This code does not seem to work in wxXT
				c->SetSelection(c->Number()-1,TRUE);
			}
			break;
		}
	}
}

PUBLIC VIRTUAL CLIST *MFORM::New_clist(
	const char *_listid,
	int nbcol,
	const char *cols[])
{
	MFORM_C *m = alloc_mf (_listid);
	CLIST *ret = new CLIST (this,_listid,nbcol,cols);
	m->c = ret;
	m->type = T_CLIST;
	return ret;
}


PUBLIC VIRTUAL void MFORM::New_clist_item(
	const char *_listid,
	const char *_itemid,
	const char *vals[])
{
	for (int i=0; i<nbc; i++){
		MFORM_C *m = tbc[i];
		if (m->type == T_CLIST && strcmp(m->id,_listid)==0){
			CLIST *c = (CLIST*)m->c;
			c->New_item(_itemid,vals);
			break;
		}
	}
}

PUBLIC VIRTUAL SHEET *MFORM::New_sheet(
	const char *_sheetid,
	int nbcol,
	const char *cols[])
{
	MFORM_C *m = alloc_mf (_sheetid);
	SHEET *ret = new SHEET (this,_sheetid,nbcol,cols);
	m->c = ret;
	m->type = T_SHEET;
	return ret;
}


PUBLIC VIRTUAL void MFORM::New_sheet_item(
	const char *_sheetid,
	int row,
	int column,
	const char *val)
{
	for (int i=0; i<nbc; i++){
		MFORM_C *m = tbc[i];
		if (m->type == T_SHEET && strcmp(m->id,_sheetid)==0){
			SHEET *c = (SHEET*)m->c;
			c->New_item(row,column,val);
			break;
		}
	}
}



PUBLIC VIRTUAL COMBO *MFORM::New_combo(const char *_id, int len, const char *val)
{
	MFORM_C *m = alloc_mf (_id);
	COMBO *ret = new COMBO(this,val,len,false);
	m->c = ret;
	m->sets (val);
	m->type = T_COMBO;
	return ret;
}
PUBLIC VIRTUAL void MFORM::New_combo_item(
	const char *_id,
	const char *val1,
	const char *val2)
{
	for (int i=0; i<nbc; i++){
		MFORM_C *m = tbc[i];
		if (m->type == T_COMBO && strcmp(m->id,_id)==0){
			COMBO *c = (COMBO*)m->c;
			c->addItem(val1,val2);
			break;
		}
	}
}
PUBLIC VIRTUAL void MFORM::New_form(FORMBASE *sub)
{
	MFORM_C *m = alloc_mf();
	m->c = sub;
	m->type = T_FORM;
}
PUBLIC VIRTUAL void MFORM::New_book(FORMBASE *sub)
{
	MFORM_C *m = alloc_mf();
	m->c = sub;
	m->type = T_BOOK;
}
PUBLIC VIRTUAL MFORM *MFORM::New_form(const char *_id)
{
	MFORM_C *m = alloc_mf(_id);
	MFORM *ret = new MFORM(this,_id);
	m->c = ret;
	m->type = T_FORM;
	return ret;
}
PUBLIC VIRTUAL FORMBUTTON *MFORM::New_formbutton(const char *_id)
{
	FORMBUTTON *ret = new FORMBUTTON (this,_id);
	New_form (ret);
	return ret;
}
PUBLIC VIRTUAL FORMBUTTON *MFORM::New_formbutton()
{
	return New_formbutton ("");
}
PUBLIC VIRTUAL wxCheckBox *MFORM::New_checkbox(
	const char *_id,
	bool state,
	const char *str)
{
	MFORM_C *m = alloc_mf(_id);
	wxCheckBox *ret = new wxCheckBox (this,NULL,(char*)str);
	ret->SetValue (state);
	m->c = ret;
	m->type = T_CHECKBOX;
	return ret;
}

PUBLIC CHECKBOX_RADIO::CHECKBOX_RADIO (
	int _instance,
	bool _state)
{
	instance = _instance;
	state = _state;
}


PUBLIC void MFORM::New_radio(
	const char *_id,
	int instance,
	bool state,
	const char *str)
{
	MFORM_C *m = alloc_mf(_id);
	m->type = T_RADIO;
	CHECKBOX_RADIO *ret = new CHECKBOX_RADIO (instance,state);
	m->radio = ret;
	m->homemade = true;
	m->sets (str);
}

PUBLIC MFORM_C* MFORM::getitem (int n) const
{
	MFORM_C *ret = NULL;
	if (n >= 0 && n < nbc) ret = tbc[n];
	return ret;
}
PUBLIC void MFORM::New_component (wxWindow *comp)
{
	MFORM_C *m = alloc_mf();
	m->c = comp;
}
PUBLIC void MFORM::setsidetitle (const char *s)
{
	free (sidetitle);
	sidetitle = strdup(s);
}

PROTECTED void FORMBASE::drawbutfill(
	int nobut,
	wxPen *pentop,
	wxPen *penbot,
	bool clear)
{
	MFORM_C *c = tbc[nobut];
	int x = c->x;
	int y = c->y;
	int charh2 = (int)(2*GetCharHeight());

	int topy = y + 1;
	int endx = x+c->pref_width;
	int endy = y+charh2-2;
	int skipx = 0;

	if (clear){
		dc->SetPen (pen_back);
		dc->SetBrush (brush_back);
		dc->DrawRectangle (x,topy,c->pref_width,charh2);
	}
	dc->SetPen (pentop);
	dc->DrawLine (x,topy,endx,topy);
	topy++;
	dc->DrawLine (x,topy,endx,topy);
	if (nobut > 0 && tbc[nobut-1]->type != T_BUTTONFILL){
		dc->DrawLine (x,topy,x,endy);
		dc->DrawLine (x+1,topy,x+1,endy);
		skipx = 1;
	}
	dc->SetPen (penbot);
	int lowy = endy - 1;
	dc->DrawLine (x+skipx,lowy,endx,lowy);
	lowy++;
	dc->DrawLine (x,lowy,endx,lowy);
	if (nobut < nbc-1 && tbc[nobut+1]->type != T_BUTTONFILL){
		dc->DrawLine (endx,topy+1,endx,endy);
		dc->DrawLine (endx-1,topy+2,endx-1,endy);
	}
}
PUBLIC void FORMBASE::drawitems (int start, int end, bool clear)
{
	dc->SetFont (font_normal);
	{
		int charh2 = (int)(2*GetCharHeight());
		int miny = -charh2;
		int ww,wh;
		GetSize (&ww,&wh);
		int maxy = wh + charh2;
		for (int i=start; i<end; i++){
			MFORM_C *c = tbc[i];
			if (c->homemade
				&& c->y > miny
				&& c->y < maxy){
				int x = c->x;
				int y = c->y;
				dc->SetPen (pen_black);
				if (c->type == T_LABEL){
					dc->SetFont (font_prop);
					dc->DrawText (c->s,x+2,y+2);
					dc->SetFont (font_normal);
				}else if (c->type == T_RICHTEXT){
					richtext_draw (c->s,x+2,y+4);
				}else if (c->type == T_BUTTONFILL){
					drawbutfill (i,pen_white,pen_black,clear);
					dc->DrawText (c->s,x+3,y+4);
				}else if (c->type == T_RADIO){
					drawradio_but (c);
					dc->DrawText (c->s,x+14,y+4);
				}
			}
		}
	}
}
PUBLIC VIRTUAL void MFORM::OnPaint ()
{
	drawitems (0,nbc,false);
	if (sidetitle != NULL){
		int w_width,w_height;
		GetSize (&w_width,&w_height);
		int miny = 20;
		int maxy = w_height - 20;
		dc->SetBrush (brush_white);
		dc->SetPen (pen_white);
		dc->DrawRectangle (0,0,20,miny);
		dc->DrawRectangle (0,maxy,20,20);
		if (false){
			int i;
			for (i=1; i<miny; i += 2){
				dc->DrawLine (0,i,20,i);
			}
			for (i=maxy+1; i<w_height; i += 2){
				dc->DrawLine (0,i,20,i);
			}
		}
		dc->DrawRectangle (0,miny,20,w_height-40);
		dc->DrawRectangle (0,maxy,w_width,20);


		//g.setFont (new Font("helvetica",Font.BOLD,24));
		//FontMetrics met = g.getFontMetrics();
		int charh = (int)dc->GetCharHeight();
		int len = strlen(sidetitle);
		int y = maxy  - 3;
		dc->SetPen (pen_back);
		int limity = miny + charh-3;
		int diffy = maxy - miny;
		int htext = len * charh;
		if (htext < diffy){
			y = maxy - (diffy - htext)/2;
		}
		for (int i=0; i<len && y > limity; i++, y -= charh){
			static char tmp[2]={0,0};
			tmp[0] = sidetitle[i];
			dc->DrawText (tmp,1,y);
		}
	}
}


/*
	Locate the homemade item which was clicked.
	Return NULL if none.
*/
PUBLIC int MFORM::locate_click (wxMouseEvent & event, int type)
{
	int ret = -1;
	if (event.ButtonDown()){
		int y = (int)event.y;
		int x = (int)event.x;
		for (int i=0; i<nbc; i++){
			MFORM_C *c = tbc[i];
			if (c->type == type
				&& x > c->x
				&& x < c->x + c->pref_width
				&& y > c->y
				&& y < c->y + c->pref_height){
				ret = i;
				break;
			}
		}
	}
	return ret;
}

/*
	Check if a Buttonfill was selected
*/
PUBLIC int MFORM::locate_butfill(wxMouseEvent & event)
{
	return locate_click (event,T_BUTTONFILL);
}

PUBLIC void MFORM::animatebut (int it, bool down)
{
	wxPen *pentop = pen_white;
	wxPen *penbot = pen_black;
	if (down){
		pentop = pen_black;
		penbot = pen_white;
	}
	// Show some animation proving that the button was hit
	int left = it;
	while (left >= 0 && tbc[left]->type == T_BUTTONFILL){
		drawbutfill (left,pentop,penbot,false);
		left--;
	}
	int right = it+1;
	while (right < nbc && tbc[right]->type == T_BUTTONFILL){
		drawbutfill (right,pentop,penbot,false);
		right++;
	}
}

PUBLIC MFORM_TIMER::MFORM_TIMER(MFORM *_target, int _but)
{
	target = _target;
	but = _but;
	Start (50,true);
}
PRIVATE void MFORM_TIMER::Notify()
{
	target->animatebut (but,false);
	target->timer = NULL;
	wxPostDelete (this);
}

PUBLIC void MFORM::OnEvent(wxMouseEvent & event)
{
	int it = locate_butfill (event);
	if (it != -1){
		report_button (tbc[it]->id,false,&event);
		animatebut (it,true);
		timer = new MFORM_TIMER (this,it);
	}else{
		it = locate_click (event,T_RADIO);
		if (it != -1){
			getlogicaltop()->processradio (tbc[it]);
		}
	}
}

PUBLIC void MFORM::OnChar(wxKeyEvent &)
{
	// Do not seem to be ever called. I guess this is for widget, not panels
}

PROTECTED Bool MFORM::OnCharHook(wxKeyEvent& event)
{
	int ret = FALSE;
	long key = event.KeyCode();
	if (key == WXK_RETURN){
		MAINFORM *mf = gettop();
		const char *enteraction = mf->getenteraction();
		if (enteraction != NULL){
			char path[300];
			formbase_getabspath(mf,path);
			remadmin_setcursor (cursor_wait);
			mf->dump();
			fprintf (mform_fout,"action %s %s\n",path,enteraction);
			fflush (mform_fout);
			ret = TRUE;
		}
	}else if (vscroll != NULL){
		int viewstart,viewlength,objlength,pagelength;
		vscroll->GetValues(&viewstart, &viewlength, &objlength, &pagelength);
		int charh = (int)GetCharHeight();
		ret = TRUE;
		if (key == WXK_DOWN){
			vmoveitems (voffset + charh);
		}else if (key == WXK_UP){
			vmoveitems (voffset - charh);
		}else if (key == WXK_PRIOR){
			vmoveitems (voffset - pagelength);
		}else if (key == WXK_NEXT){
			vmoveitems (voffset + pagelength);
		}else{
			ret = FALSE;
		}
	}
	return ret;
}


PRIVATE void MFORM::distribute (
	int start,
	int end,
	int nbfill,
	int diffx)
{
	if (nbfill > 0){
		int space = diffx/nbfill;
		int newx = 0;
		for (int i=start; i<end; i++){
			MFORM_C *item = getitem(i);
			if (item->type == T_FILL){
				newx += space;
			}else if (item->c != NULL){
				int cw,ch;
				item->c->GetSize(&cw,&ch);
				item->c->SetSize (newx,0,-1,-1);
				newx += cw;
			}
		}
	}else{
		// Strech only one item on the line
		// One day, we will need a weight concept
		for (int i=start; i<end; i++){
			MFORM_C *item = getitem(i);
			if (item->type == T_FORM || item->type == T_BOOK){
				FORMBASE *b = (FORMBASE*)item->c;
				if (b->may_stretch()){
					int cw,ch;
					item->c->GetSize(&cw,&ch);
					b->stretch (diffx+cw,ch);
					break;
				}
			}
		}
	}
}
// Enlarge a dialog so it fits a constraint
PUBLIC void MFORM::stretch (
	int new_width,
	int)		// new_height: Not supported yet
				// Only horizontally strechable items so far
{
	int diffx = new_width - pref_width;
	if (diffx > 0){
		int start = 0;
		int nbfill = 0;
		for (int i=0; i<nbc; i++){
			MFORM_C *item = getitem(i);
			if (item->type == T_NEWLINE){
				distribute (start,i,nbfill,diffx);
				start = i+1;
				nbfill = 0;
			}else if (item->type == T_FILL){
				nbfill++;
			}
		}
		distribute (start,nbc,nbfill,diffx);
		SetSize (new_width,-1);
	}
}
// Enlarge the items of a dialog after the user has resized the window
// Use the standard strategy of the weights to distribute the
// available space to each components. For complex layout, it is
// much easier to redefine resizeitems().
PUBLIC void MFORM::resizeitems(
	int,	// diffx
	int)	// diffy
{
	#if 0
	MFORM_C tbexph[] = new mform_c[20];	// Item we may expand horizontally
	mform_c tbexpv[] = new mform_c[20];	// Item we may expand vertically
	int nbexpv=0;
	int nbexph=0;
	int totalh = 0;
	int totalv = 0;
	for (int i=0; i<nbc; i++){
		mform_c item = getitem(i);
		if (item->weightx > 0){
			tbexph[nbexph++] = item;
			totalh += item->weightx;
		}
		if (item->weighty > 0){
			tbexpv[nbexpv++] = item;
			totalv += item->weighty;
		}
	}
	for (int i=0; i<nbexph; i++){
		mform_c item = tbexph[i];
		Dimension d = item->c->preferredSize();
		item->c->resize(d.width+diffx*item->weightx/totalh,d.height);
	}
	for (int i=0; i<nbexpv; i++){
		mform_c item = tbexpv[i];
		Dimension d = item->c->preferredSize();
		item->c->resize(d.width,d.height+diffy*item->weighty/totalv);
	}
	#endif
}



