#pragma interface
#ifndef CMDSOCK_H
#define CMDSOCK_H

const int MAX_CLIENT=100;

struct SOCK_INFO{
	int handle;		// Handle (not only sockets)
	struct {
		int set;	// Max delay without activity
		int cur;	// Activity accumulator
	}idle;
	int actif;		// Any activity on this handle ?
};



class CMDSOCK{
	int listen_handle;
	SOCK_INFO inf[MAX_CLIENT];
	int nbcli;			// How many active connexion in
					// inf[]
	int actif;			// Current index in tbactif[],
					// see readnext().
	/*~PROTOBEG~ CMDSOCK */
public:
	CMDSOCK (const char *portname, int reuseaddr);
	CMDSOCK (int port, int reuseaddr);
	void addcli (int fd);
	void addcli (int fd, int timeout);
	void closecli (int fd);
	void forgetcli (int fd);
	int getnbcli (void);
private:
	void init (int port, int reuseadr);
public:
	int is_ok (void);
	int listen (long timeout);
	int readnext (void *buf, int size, int &cli);
	~CMDSOCK (void);
	/*~PROTOEND~ CMDSOCK */
};


#endif

