#include <dialog.h>
#include "builder.h"
#include "builder.m"

PUBLIC MENU_ENTRY::MENU_ENTRY()
{
	context = (char)MENU_UNKNOWN;
	submenu = NULL;
	subdia = NULL;
}


static const char *tbctxid[]={
	"MENU_UNKNOWN",
	"MENU_NETWORK_CLIENT",
	"MENU_NETWORK_SERVER",
	"MENU_NETWORK_MISC",
	"MENU_MAIN_CONFIG",
	"MENU_MAIN_CONTROL",
	"MENU_CONTROL",
	"MENU_NETWORK_BOOT",
	"MENU_CTRL_FILE",
	"MENU_USER_POLICIES",
	NULL,
};


PUBLIC int MENU_ENTRY::edit ()
{
	DIALOG dia;
	dia.newf_str (MSG_U(F_TITLE,"Entry title"),title);
	dia.last_noempty();
	dia.newf_str (MSG_U(F_ICON,"Icon name (opt))"),icon);
	FIELD_COMBO *comb = dia.newf_list (MSG_U(F_INSMENU,"Insert into menu")
		,context);
	static const char *tbctx[]={
		MSG_U(O_UNKNOWN,"Not associated with anu menu"),
		MSG_U(O_NETCLIENT,"Client section of the network menu"),
		MSG_U(O_NETSERVER,"Server section of the network menu"),
		MSG_U(O_NETMISC,"Misc section of the network menu"),
		MSG_U(O_MAINCONFIG,"Config section of the main linuxconf menu"),
		MSG_U(O_MAINCONTROL,"Control section of the main linuxconf menu"),
		MSG_U(O_CONTROL,"Control panel"),
		MSG_U(O_NETBOOT,"Boot services section of the network menu"),
		MSG_U(O_CTRLFILE,"Control file and systems"),
		MSG_U(O_USERPOLICIES,"User account policies section"),
	};
	for (int i=0; tbctxid[i] != NULL; i++){
		comb->addopt (tbctxid[i],tbctx[i]);
	}
	int nof = 0;
	int ret = -1;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_ONEENTRY,"One menu entry")
			,""
			,help_menuentry
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_DEL);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_DEL){
			if (xconf_delok()){
				ret = 1;
				break;
			}
		}else{
			ret = 0;
			break;
		}
	}
	return ret;
}

PUBLIC MENU_ENTRY *MENU_ENTRIES::getitem (int no) const
{
	return (MENU_ENTRY*)ARRAY::getitem(no);
}

PUBLIC int MENU_ENTRIES::edit ()
{
	DIALOG_RECORDS dia;
	int nof = 0;
	while (1){
		if (dia.getnb()==0){
			dia.newf_head ("",MSG_U(H_MENUENTRIES,"In menu\tTitle\tIcon"));
			for (int i=0; i<getnb(); i++){
				MENU_ENTRY *e = getitem(i);
				char buf[200];
				snprintf (buf,sizeof(buf)-1,"%s\t%s",e->title.get(),e->icon.get());
				dia.new_menuitems (tbctxid[e->context],buf);
			}
		}
		MENU_STATUS code = dia.editmenu (MSG_U(T_ENTRIES,"One menu")
			,""
			,help_menu
			,nof,MENUBUT_ADD);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ADD){
			MENU_ENTRY *e = new MENU_ENTRY;
			int ok = e->edit();
			if (ok != 0){
				delete e;
			}else{
				add (e);
				dia.remove_all();
			}
		}else if (nof>=0 && nof <getnb()){
			MENU_ENTRY *e = getitem(nof);
			int ok = e->edit();
			if (ok != -1){
				if (ok == 1){
					remove_del (e);
				}
				dia.remove_all();
			}
		}
	}
	return 0;
}

