
#include <std.h>
#include <list/screens.h>
#include <list/sorting.h>
#include <list/colors.h>
#include <interface/dialogs.h>
#include <interface/coreui.h>
#include <func/keys.h>

#include "menu.h"

#define _ALG ((COLS)/6)

extern void HelpDialog();

MenuDrop::menu_item_list MenuDrop::mi[] =
{
	{
	MenuDrop::M_Toggles, DefaultKeys::depend_toggle, "Toggle dependencies"}
	,
	{
	MenuDrop::M_Toggles, DefaultKeys::descwin_toggle, "Toggle description"}
	,
	{
	MenuDrop::M_Toggles, DefaultKeys::viewmode_toggle, "Toggle verbose view mode"}
	,
	{
	MenuDrop::M_Toggles, DefaultKeys::sort_method, "Change list sort method(s)"}
	,
	{
	MenuDrop::M_Toggles, DefaultKeys::search, "Search through the list"}
	,
	{
	MenuDrop::M_Toggles, DefaultKeys::reset_markers, "Reset items marked by search"}
	,
	{
	MenuDrop::M_Toggles,::ui_seek_nextmatched, "Move to next search match"}
	,
	{
	MenuDrop::M_Filters,::filter_add_single, "Add new filter"}
	,
	{
	MenuDrop::M_Filters,::filter_revoke_all, "Remove active filters"}
	,
	{
	MenuDrop::M_Filters,::filter_display_all, "Display filter list"}
	,
	{
	MenuDrop::M_Filters,::filter_invert, "Invert filter polarity"}
	,
	{
	MenuDrop::M_Modifiers, DefaultKeys::pkg_install, "Mark pkg for install/upgrade"}
	,
	{
	MenuDrop::M_Modifiers, DefaultKeys::pkg_remove, "Mark pkg for remove"}
	,
	{
	MenuDrop::M_Modifiers, DefaultKeys::pkg_purge, "Mark pkg for purge"}
	,
	{
	MenuDrop::M_Modifiers, DefaultKeys::dist_upgrade, "Upgrade all possible packages"}
	,
	{
	MenuDrop::M_Functions, HelpDialog, "Display key bindings"}
	,
	{
	MenuDrop::M_Functions, DefaultKeys::complete_pending, "Complete pending install/removals"}
	,
	{
	MenuDrop::M_Functions, DefaultKeys::update_lists, "Update available package lists"}
	,
	{
	MenuDrop::M_Functions, DefaultKeys::reread_cache, "Reinitialize the apt cache"}
	,
	{
	MenuDrop::M_Functions, DefaultKeys::quit, "Quit program"}
	,
	{
	MenuDrop::M_Movement,::ui_arrow_down, "Move to the next package"}
	,
	{
	MenuDrop::M_Movement,::ui_arrow_up, "Move to the previous package"}
	,
	{
	MenuDrop::M_Movement,::ui_seek_start, "Move to the start of the list"}
	,
	{
	MenuDrop::M_Movement,::ui_seek_end, "Move to the end of the list"}
	,
	{
	MenuDrop::M_Movement,::ui_page_down, "Move down one screen length"}
	,
	{
	MenuDrop::M_Movement,::ui_page_up, "Move up one screen length"}
	,
	{
	MenuDrop::M_Movement, DefaultKeys::dscroll_left, "Scroll description left (Verbose only)"}
	,
	{
	MenuDrop::M_Movement, DefaultKeys::dscroll_right, "Scroll description right (Verbose only)"}
	,
	{
	MenuDrop::M_Movement,::ui_scroll_descwin_up, "Scroll package description UP"}
	,
	{
	MenuDrop::M_Movement,::ui_scroll_descwin_down, "Scroll package description DOWN"}
	,
	{
	MenuDrop::M_Movement,::ui_divider_prev, "Move to the PREVIOUS package divider"}
	,
	{
	MenuDrop::M_Movement,::ui_divider_next, "Move to the NEXT package divider"}
	,
	{
	(MenuDrop::Menu) - 1, NULL, NULL}
};

MenuDrop::MenuDrop(Menu M)
{
	Current = M;

	geometry(-1, -1, 1, _ALG * M);
	if (M == M_Sorting)
		sorting();
	else
		import_menu_items(M);
	initialize();
	Window->ChangeColor(Pair(COLOR_BLUE, COLOR_BLUE) | A_BOLD, Pair(COLOR_GREEN, COLOR_BLUE) | A_BOLD);
	drawall();
	Window->Refresh();
	select();
}

void MenuDrop::move_toward(Menu M)
{
	Current = M;

	deinitialize();
	geometry(-1, -1, 1, _ALG * M);
	clear_menu_items();
	if (M == M_Sorting)
		sorting();
	else
		import_menu_items(M);
	ui_refresh_current();
	initialize();
	Window->ChangeColor(Pair(COLOR_BLUE, COLOR_BLUE) | A_BOLD, Pair(COLOR_GREEN, COLOR_BLUE) | A_BOLD);
	drawall();
	Window->Refresh();
}

void MenuDrop::clear_menu_items()
{
	free_memory();
}

bool MenuDrop::external_key_handler(int key)
{
	if (key == KEY_RIGHT)
	{
		switch (Current)
		{
		case M_Functions:
			move_toward(M_Movement);
			break;
		case M_Movement:
			move_toward(M_Toggles);
			break;
		case M_Toggles:
			move_toward(M_Modifiers);
			break;
		case M_Modifiers:
			move_toward(M_Filters);
			break;
		case M_Filters:
			move_toward(M_Sorting);
			break;
		case M_Sorting:
			move_toward(M_Functions);
			break;
		}
	}
	else if (key == KEY_LEFT)
	{
		switch (Current)
		{
		case M_Functions:
			move_toward(M_Sorting);
			break;
		case M_Movement:
			move_toward(M_Functions);
			break;
		case M_Toggles:
			move_toward(M_Movement);
			break;
		case M_Modifiers:
			move_toward(M_Toggles);
			break;
		case M_Filters:
			move_toward(M_Modifiers);
			break;
		case M_Sorting:
			move_toward(M_Filters);
			break;
		}
	}
	else if (key == '\n')
	{
		if (Selection()->keyhandler != NULL)
		{
			Selection()->keyhandler(key);
			return false;
		}
	}

	return true;
}

void MenuDrop::import_menu_items(Menu M)
{
	for (menu_item_list * P = mi; P->caption != NULL; P++)
		if (M == P->menu)
			addline(P->caption, (void (*)(int)) P->binding);
}

void MenuDrop::sorting()
{
	if (screen->Sorting->Exists(sortorderlist::Section))
		addline("[$3#X$!] Section");
	else
		addline("[ ] Section");
	if (screen->Sorting->Exists(sortorderlist::Priority))
		addline("[$3#X$!] Priority");
	else
		addline("[ ] Priority");
	if (screen->Sorting->Exists(sortorderlist::Status))
		addline("[$3#X$!] State");
	else
		addline("[ ] State");
	if (screen->Sorting->Exists(sortorderlist::PkgName))
		addline("[$3#X$!] Pkg Name");
	else
		addline("[ ] Pkg Name");
	if (screen->Sorting->Exists(sortorderlist::Size))
		addline("[$3#X$!] Arch Size");
	else
		addline("[ ] Arch Size");
	if (screen->Sorting->Exists(sortorderlist::Instsize))
		addline("[$3#X$!] Inst Size");
	else
		addline("[ ] Inst Size");
}

#ifdef HAVE_LIBGPM
int MenuDrop::gpm_handler(Gpm_Event * event)
{
	if (Gpm_StrictSingle(event->type))
	{
		for (unsigned I = bound_start; I < bound_end; I++)
		{
			unsigned K = I - bound_start;

			if (((sy + 2 + K) == event->y) && (sx + 2 <= event->x && event->x <= sx + lx - 1))
			{
				cursor = I;
				drawall();
			}
		}
	}
	else if (Gpm_StrictDouble(event->type))
	{
		for (unsigned I = bound_start; I < bound_end; I++)
		{
			unsigned K = I - bound_start;

			if (((sy + 2 + K) == event->y) && (sx + 2 <= event->x && event->x <= sx + lx - 1))
				return -1;
		}
		return -2;
	}

	return 0;
}
#endif
