
#ifndef _dialogs_H
#define _dialogs_H

#include "wrappers.h"
#include <string>

#ifdef HAVE_LIBGPM
#include <func/mouse.h>
#endif

unsigned char ui_dialog(int, char *, char *, ...);

class MenuDrop;

/*
 * Provide the basic implementation of a scrolling dialog that can be
 * placed at any position on the screen, at any width/height, or get the
 * dimensions from the width of the inserted text strings and the length
 * of the list it is to operate on.
 *
 * It implements two methods to deal with user input:
 *
 *     i)  Function that handles a keypress on a certain item.
 *     ii) Return the key from the select function. (NOT IMPLEMENTED YET)
 */
class Dialog
{
	friend MenuDrop;

      private:
	struct Entry
	{
		char *text;
		void (*keyhandler) (int);
		unsigned char key;
	};

	Entry *Lines[200];

	UniqueWindow *Window;
	string TitleText;
	int ly, lx, sy, sx;
	unsigned bound_start, bound_end, cursor;
	unsigned linecount, width;
	bool Initialized;

	void initialize();
	void deinitialize();
	void select();

	virtual void drawall();
	virtual void drawline(int row, unsigned lkey);

      public:
#ifdef HAVE_LIBGPM
	 virtual int gpm_handler(Gpm_Event *);
#endif
	virtual bool external_key_handler(int);

	Entry *Selection()
	{
		return Lines[cursor];
	};
	void free_memory();
	void addline(string, void (*)(int));
	void addline(string);
	void geometry(int, int, int, int);
	inline void title(string text)
	{
		TitleText = text;
	};
	virtual void execute();

	 Dialog();
	 virtual ~ Dialog();
};

extern Dialog *active_dialog;

#endif
