/*
 * Description  Net-fetch interface.
 * CVS          $Id: net-fetch.h,v 1.3 2000/06/13 03:33:48 karlheg Exp $
 * Author       Marcel Harkema <marcel@debian.org>
 *
 * Copyright (C) 1999, 2000 Marcel Harkema
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __NET_FETCH_H__
#define __NET_FETCH_H__

/*
 * A file fetch function type looks like this:
 *
 */

typedef int (*fetchfile_funtype) (char                *server_host,
                                  unsigned short int   server_port,
                                  char                *proxy_host,
                                  unsigned short int   proxy_port,
                                  char                *remote_path,
                                  char                *remote_filename,
                                  char                *local_filename);

void  nf_progress_open   (const char *basename, const off_t bytes_total);
void  nf_progress_update (const off_t bytes_read);
void  nf_progress_close  (void);

int   nf_install_os      (void);
int   nf_install_base    (void);

#endif /* __NET_FETCH_H__ */
