#ifndef _DBOOTSTRAP_H_
#define _DBOOTSTRAP_H_

#define USER_SETTINGS_DIR  "/root"
#define USER_SETTINGS_FILE "/root/dbootstrap_settings"

/* Some useful definitions swiped from busybox. */
#define FALSE   ((int) 1)
#define TRUE    ((int) 0)
#define BUF_SIZE        8192

#define KERNEL_VERSION(a,b) (((a) << 16) + ((b) << 8))

/* temporary config file for keyboard settings */
#define KEYBD_SETTINGS_FILE "/tmp/keybd_settings"

#define ARCHIVE_LOCATION "dists/potato/main/disks-%s/current"
/* See: "main.c:setup_image_names()" */
#define BASETGZ "base2_2.tgz"
#define ADDONS  "addons.tgz"
#define KERDISKFILE "rescue.bin"
#define DRVTGZFILE "drivers.tgz"

/* see netconfig.c */
#define NC_HOSTNAME_FILE   "/etc/hostname"

#if defined(_TESTING_) || defined (_BOXTESTING_) || defined (_STESTING_) || defined(_EXETESTING_)
#	define TRMFILE "test.trm"
#else
#	define TRMFILE "/etc/messages.trm"
#endif
#ifdef USE_LANGUAGE_CHOOSER
#	define TRMBACKUP "/etc/messages.en"
#else
#	define TRMBACKUP "./po/C.trm"
#endif

#ifdef _TESTING_
#	define _(String) String
#else
#	include <libintl.h>
#	define _(String) gettext(String)
#endif

#define  CLEAR "[H[J"

#define SYSLOG_IDENT "dbootstrap"
#define INFOMSG(format...)				\
	openlog(SYSLOG_IDENT, LOG_PID, LOG_USER);	\
	syslog(LOG_INFO, format);			\
	closelog()
#define ERRMSG(format...)				\
	openlog(SYSLOG_IDENT, LOG_PID, LOG_USER);	\
	syslog(LOG_ERR, format);			\
	closelog()
#ifdef _TESTING_
# define DEBUGMSG(format...)				\
	syslog(LOG_DEBUG, format)
#else
# define DEBUGMSG(format...)				\
	if ( bootargs.isdebug ) {			\
	  openlog(SYSLOG_IDENT, LOG_PID, LOG_USER);	\
 	  syslog(LOG_DEBUG, format);			\
	  closelog();					\
	}
#endif

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <dirent.h>
#include <time.h>
#include <utime.h>
#include <syslog.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <unistd.h>
#include <ctype.h>
#include "../libfdisk/fdisk.h"
#include "boxes.h"

#define NAME_ISDIR(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	 S_ISDIR((statbuf)->st_mode))

#define NAME_ISREG(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	 S_ISREG((statbuf)->st_mode))

#define NAME_ISLNK(name,statbuf)		\
	((! lstat(name,statbuf)) &&		\
	 S_ISLNK((statbuf)->st_mode))

#define NAME_ISEXE(name,statbuf)		\
	((! stat(name,statbuf))     &&		\
	S_ISREG((statbuf)->st_mode) &&		\
	(S_IXUSR & (statbuf)->st_mode))

#define NAME_ISCHR(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	S_ISCHR((statbuf)->st_mode))

#define NAME_ISBLK(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	S_ISBLK((statbuf)->st_mode))

#define NAME_ISDEV(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	(S_ISCHR((statbuf)->st_mode) ||		\
	 S_ISBLK((statbuf)->st_mode)))

#define NAME_ISFIFO(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	S_ISFIFO((statbuf)->st_mode))

#define NAME_ISSOCK(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	S_ISSOCK((statbuf)->st_mode))

#define NAME_ISNODE(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	(S_ISCHR((statbuf)->st_mode)  ||	\
	 S_ISBLK((statbuf)->st_mode)  ||	\
	 S_ISFIFO((statbuf)->st_mode) ||	\
	 S_ISSOCK((statbuf)->st_mode))

struct BootArgs {
  char *root;
  char *lang;
  char *kbd;
  char *mouse; 
  char *disksize;
  char *flavor;
  int cdrom;
  int ismono;
  int isdebug;
  int isverbose;
  int isquiet;
} bootargs;

enum extract_type {
    kernel, base,
#if #cpu(alpha)
    milo, apb
#endif
} disqtype;

/* added for the modules preload */
#define MOD_SAVE_DIR "/tmp/mod-save-dir"
#define MOD_SAVE_FILE "/tmp/mod-save-dir/save.txt"

/* We should plan to do away with this static buffer and use asprintf()/free() throughought the code. */
#define PRTBUFSIZE 3364		/* (ceil(log2(80*43)))^2 */
char prtbuf[PRTBUFSIZE];
char *InstallationRootDevice,*Archive_Dir; 
struct fdisk_partition *Boot;
struct fdisk_partition *Root;
int noSwap, notCreatedBootFloppy, notInstalledLILO;

static const char * fs_type_tab[];

struct fdisk_partition *
    select_not_mounted(const char *message, const char *title, int ntypes, ...);

/* Predicates */
int supported_filesystem(const char* fsname);
int have_unused_partitions (void);
int has_cdrom (void);

/* Utilities */
int choose_medium(void);
int mount_and_check_floppy (char *device, const char *type, const char *text);
int getFloppies(const char *message, const char *device, const char *filename, char **basenames, const char *series);
const char* target_path(const char* s);
char* get_device(const char* diskimage); /* extract_kernel.c */
void release_device(const char* device); /* extract_kernel.c */

/* Semi internal use only */
int install_floppy (char *device, const char *type, const char *text); /* extract_kernel.c */
int install_from_file (const char *filename, const char *descr); /* extract_kernel.c */
int extract_from_file (const char *fil, const char *descr); /* extract_base.c */

int configure_keyboard_m (void);

/* Main menu callouts */
int main_menu (void);
int release_notes(const char *);
int partition_disk (void);
int init_swap (void);
int activate_swap (void);
int no_swap (void);
int init_linux (void);
int mount_any (void);
int unmount_any (void);
int configure_keyboard (char* kbd);
int extract_kernel_and_modules (void);
int configure_drivers (void);
int configure_hostname (void);
int configure_network (void);
int configure_pcmcia (void);
int extract_base (void);
int make_bootable (void);
int make_boot_floppy (void);
int configure_base (void);
int view_partitions (void);
int interactive_shell (void);
int reboot_system (void);
int chroot_start (void);
int load_modules_after_boot();
int load_modules_after_boot_ac();
void add_modules_from_floppy(void);
int edit_append_line();

/**  ToDo: Make these into a shared object library  **/
/* PETA: functionns from old busybox */
char * block_device(char *name);

/* Code swiped from busybox, and now out of sync. */
extern int isDirectory(const char *name);
extern int fullWrite(int fd, const char *buf, int len);
extern int copyFile(const char *srcName, const char *destName, int setModes,
		    int followLinks);
/* This has bugs fixed in the busybox version... */
extern int recursiveAction(const char *fileName, int recurse, int followLinks, int depthFirst,
	  int (*fileAction) (const char *fileName, struct stat* statbuf),
	  int (*dirAction) (const char *fileName, struct stat* statbuf));
extern int del_loop(const char *device);
extern int set_loop(const char *device, const char *file, int offset, int *loopro);
extern char *find_unused_loop_device (void);
extern void get_kver(void);

extern char *kver;
extern char *append_opts;
extern char kernel_image_path[PATH_MAX + 1];
extern char drivers_path[PATH_MAX + 1];
extern int serialConsole;
extern char *Arch2;

#ifdef USE_LANGUAGE_CHOOSER
#include "langs/langs.h"

extern const struct language_item *lang;
#endif

#if #cpu (m68k)

# define SERIAL_CONSOLE		/* serial console recognized */
# define DO_EJECT		/* auto eject floppy drives */
# define SCSI_FLOPPY
# define NFSROOT		/* network boot */
# define LOCALTIME		/* ask for GMT or localtime clock setup */
void find_scsi_floppy (void);

#elif #cpu (sparc)

# define SERIAL_CONSOLE		/* serial console recognized */
# define DO_EJECT		/* auto eject floppy drives */
# define NFSROOT		/* network boot */

#elif #cpu (i386)

# define SERIAL_CONSOLE		/* serial console recognized */
# define NFSROOT		/* network boot */
# define LOCALTIME		/* ask for GMT or localtime clock setup */

#elif #cpu (powerpc)

# define SERIAL_CONSOLE		/* serial console recognized */
# define DO_EJECT		/* auto eject floppy drives */
# define NFSROOT		/* network boot */
# define LOCALTIME		/* ask for GMT or localtime clock setup */

#elif #cpu (alpha)

# define SERIAL_CONSOLE		/* serial console recognized */
# define NFSROOT		/* network boot */
# define LOCALTIME		/* ask for GMT or localtime clock setup */

extern int srm_boot; /* flag - did we boot from SRM or MILO? */
extern char milo_binary_path[PATH_MAX+1];

#elif #cpu (arm)

# define SERIAL_CONSOLE		/* serial console recognized */
# define NFSROOT		/* network boot */

#endif

#ifdef DO_EJECT
void eject_floppy(const char *device);
int do_eject (void);
#else
# define eject_floppy(device)	/* nada */
#endif
#endif
