// pkg_subtree.cc
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  (trivial :) ) implementations for pkg_subtree.h

#include "pkg_subtree.h"

#include "vs_tree.h"

void pkg_subtree::display(vs_tree *win, int y)
{
  vs_subtree<pkg_tree_node, tag_sort_policy>::display(win, y, label.c_str());
}

const char *pkg_subtree::tag() const
{
  return label.c_str();
}

void pkg_subtree::sort()
{
  vs_subtree<pkg_tree_node, tag_sort_policy>::sort(tag_sort_policy());
}

bool pkg_subtree::dispatch_char(chtype ch)
{
  if(pkg_tree_node::dispatch_char(ch))
    return true;
  else
    return vs_subtree<pkg_tree_node, tag_sort_policy>::dispatch_char(ch);
}
