// pkg_description_treeitem.cc
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Implementations for the pkg_description types.

#include "pkg_description_treeitem.h"

#include "apt.h"

pkg_description::pkg_description(pkgCache::VerIterator ver, const string &_title):title(_title)
{
  string long_desc=apt_package_records->Lookup(ver.FileList()).LongDesc();
  unsigned int start=0, nextnl=long_desc.find('\n',start);

  if(nextnl!=string::npos)
    {
      children.push_back(new pkg_description_item(string(ver.ParentPkg().Name())+" - "+string(long_desc,start,nextnl-start)));
      start=nextnl+1;
      nextnl=long_desc.find('\n', start);
    }

  for(nextnl=long_desc.find('\n', start); nextnl!=string::npos; start=nextnl+1,nextnl=long_desc.find('\n', start))
    {
      string thisline(long_desc, start, nextnl-start);

      if(thisline!=" .")
	children.push_back(new pkg_description_item(string(thisline,1)));
      else
	children.push_back(new pkg_description_item(string("")));
    }

  // Ewww.   I have to do one extra loop iteration manually :(
  string thisline(long_desc, start, nextnl-start);

  if(thisline!=" .")
    children.push_back(new pkg_description_item(string(thisline,1)));
  else
    children.push_back(new pkg_description_item(string("")));
}

pkg_description_screen::pkg_description_screen(pkgCache::VerIterator ver)
{
  pkg_description *newtree=new pkg_description(ver, string("Description of ")+ver.ParentPkg().Name());

  set_root(newtree, false);

  set_header((string("Description of ")+ver.ParentPkg().Name()).c_str());

  prev=vscreen_show(this);
}

void pkg_description_screen::dispatch_char(chtype ch)
{
  if(global_bindings.key_matches(ch, "ExitScreen"))
    {
      vscreen_show(prev);
      vscreen_preparedelete(this);
    }
  else
    vs_tree::dispatch_char(ch);
}
