// download_screen.h  (this is -*-c++-*- )
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  This acts as a progress meter for a download.

#ifndef DOWNLOAD_SCREEN_H
#define DOWNLOAD_SCREEN_H

#include <apt-pkg/acquire.h>
#include <hash_map.h>

#include "vs_tree.h"

class download_item;

struct hash<void *>
{
  size_t operator()(void * __x) const { return (size_t) __x; }
};

class download_tree:public vs_subtree_generic
{
public:
  download_tree():vs_subtree_generic(true) {}

  void display(vs_tree *win, int y) {vs_subtree_generic::display(win, y, "ERROR: SHOULD NOT APPEAR");}
  const char * tag() const {return "download tree";}
};

class download_screen:public vs_tree, public pkgAcquireStatus
{
  typedef hash_map<void *, download_item *> downloadmap;
  downloadmap active_items;
  // Makes it easy to find a currently downloading item when we get a hit
  // for it.

  vscreen *prev;
  // The screen that was being displayed before we started running the
  // download.

  bool finished;
  // If this is true, the status bar will be displayed as usual (as opposed to
  // being a progress meter)

  download_item *get_itm(pkgAcquire::ItemDesc &itmdesc)
  {
    downloadmap::iterator found=active_items.find(itmdesc.Owner);
    assert(found!=active_items.end());

    return found->second;
  }

  download_tree *contents;

public:
  download_screen():prev(NULL),finished(false) {contents=new download_tree; set_root(contents);}

  bool MediaChange(string media, string drive) {return false;}
  void IMSHit(pkgAcquire::ItemDesc &itmdesc);
  void Fetch(pkgAcquire::ItemDesc &itmdesc);
  void Done(pkgAcquire::ItemDesc &itmdesc);
  void Fail(pkgAcquire::ItemDesc &itmdesc);
  bool Pulse(pkgAcquire *Owner);
  void Start();
  void Stop();

  void paint_status();

  virtual ~download_screen();
};

class OpProgress;

void do_pkglist_update(OpProgress *load_progress);
// Performs a package-list update.  load_progress is a progress object which
// should be used to display the progress when the package cache is reloaded.
//
// It might be a good idea to move this into the pkg_tree object at some
// point, along with do_install_run.

void do_install_run(OpProgress *load_progress);
// Installs packages.  load_progress is a progress object used to display the
// progress when the package cache is reloaded.

#endif
